/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.twitter.entity;

import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.Set;

@Entity(name="TwitterTweets")
@Table(name="TWITTER_TWEETS")
@NamedQueries(value={@NamedQuery(name="TwitterTweets.getTweetByLink", query="SELECT tweet FROM TwitterTweets tweet WHERE tweet.tweetLink = :tweetLink"), @NamedQuery(name="TwitterTweets.getTweetsIds", query="SELECT tweet.tweetId FROM TwitterTweets tweet ORDER BY tweet.tweetId ASC")})
public class TwitterTweetEntity
implements Serializable {
    private static final long serialVersionUID = -4871930064565777769L;
    @Id
    @SequenceGenerator(name="SEQ_TWITTER_ACCOUNTS_ID", sequenceName="SEQ_TWITTER_ACCOUNTS_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_TWITTER_ACCOUNTS_ID")
    @Column(name="TWEET_ID")
    private Long tweetId;
    @Column(name="TWEET_LINK")
    private String tweetLink;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="TWITTER_TWEET_LIKERS", joinColumns={@JoinColumn(name="TWEET_ID")})
    @Column(name="LIKER_USERNAME")
    private Set<String> likers;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="TWITTER_TWEET_RETWEETERS", joinColumns={@JoinColumn(name="TWEET_ID")})
    @Column(name="RETWEETER_USERNAME")
    private Set<String> retweeters;

    public Long getTweetId() {
        return this.tweetId;
    }

    public String getTweetLink() {
        return this.tweetLink;
    }

    public Set<String> getLikers() {
        return this.likers;
    }

    public Set<String> getRetweeters() {
        return this.retweeters;
    }

    public void setTweetId(Long tweetId) {
        this.tweetId = tweetId;
    }

    public void setTweetLink(String tweetLink) {
        this.tweetLink = tweetLink;
    }

    public void setLikers(Set<String> likers) {
        this.likers = likers;
    }

    public void setRetweeters(Set<String> retweeters) {
        this.retweeters = retweeters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TwitterTweetEntity)) {
            return false;
        }
        TwitterTweetEntity other = (TwitterTweetEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$tweetId = this.getTweetId();
        Long other$tweetId = other.getTweetId();
        if (this$tweetId == null ? other$tweetId != null : !((Object)this$tweetId).equals(other$tweetId)) {
            return false;
        }
        String this$tweetLink = this.getTweetLink();
        String other$tweetLink = other.getTweetLink();
        if (this$tweetLink == null ? other$tweetLink != null : !this$tweetLink.equals(other$tweetLink)) {
            return false;
        }
        Set<String> this$likers = this.getLikers();
        Set<String> other$likers = other.getLikers();
        if (this$likers == null ? other$likers != null : !((Object)this$likers).equals(other$likers)) {
            return false;
        }
        Set<String> this$retweeters = this.getRetweeters();
        Set<String> other$retweeters = other.getRetweeters();
        return !(this$retweeters == null ? other$retweeters != null : !((Object)this$retweeters).equals(other$retweeters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TwitterTweetEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $tweetId = this.getTweetId();
        result = result * 59 + ($tweetId == null ? 43 : ((Object)$tweetId).hashCode());
        String $tweetLink = this.getTweetLink();
        result = result * 59 + ($tweetLink == null ? 43 : $tweetLink.hashCode());
        Set<String> $likers = this.getLikers();
        result = result * 59 + ($likers == null ? 43 : ((Object)$likers).hashCode());
        Set<String> $retweeters = this.getRetweeters();
        result = result * 59 + ($retweeters == null ? 43 : ((Object)$retweeters).hashCode());
        return result;
    }

    public String toString() {
        return "TwitterTweetEntity(tweetId=" + this.getTweetId() + ", tweetLink=" + this.getTweetLink() + ", likers=" + this.getLikers() + ", retweeters=" + this.getRetweeters() + ")";
    }
}

