/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.twitter.service;

import io.meeds.gamification.twitter.BaseTwitterTest;
import io.meeds.gamification.twitter.model.RemoteTwitterAccount;
import io.meeds.gamification.twitter.model.Tweet;
import io.meeds.gamification.twitter.model.TwitterAccount;
import io.meeds.gamification.twitter.model.TwitterTrigger;
import java.util.ArrayList;
import java.util.Set;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.gatein.common.util.Tools;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TwitterServiceTest
extends BaseTwitterTest {
    private static final String ADMIN_USER = "root1";
    private static final String USER = "root";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.registerAdministratorUser(ADMIN_USER);
        this.registerInternalUser(USER);
    }

    @Test
    public void testAddTwitterAccount() throws Exception {
        Assert.assertThrows(IllegalAccessException.class, () -> this.twitterService.addTwitterAccount("twitterUsername", USER));
        this.twitterService.saveTwitterBearerToken("bearerToken", ADMIN_USER);
        RemoteTwitterAccount remoteTwitterAccount = new RemoteTwitterAccount(1L, "username", "name", "description", "avatarUrl");
        RemoteTwitterAccount remoteTwitterAccount1 = new RemoteTwitterAccount(2L, "username1", "name1", "description1", "avatarUrl1");
        Mockito.when((Object)this.twitterConsumerService.retrieveTwitterAccount("twitterUsername", "bearerToken")).thenReturn((Object)remoteTwitterAccount);
        Mockito.when((Object)this.twitterConsumerService.retrieveTwitterAccount("twitterUsername1", "bearerToken")).thenReturn((Object)remoteTwitterAccount1);
        ArrayList<TwitterTrigger> twitterTriggers = new ArrayList<TwitterTrigger>();
        TwitterTrigger twitterTrigger = new TwitterTrigger("mentionAccount", "user1", 1254555L, "tweet", 11222121L);
        TwitterTrigger twitterTrigger1 = new TwitterTrigger("mentionAccount", "user2", 12548855L, "tweet", 11222121L);
        twitterTriggers.add(twitterTrigger);
        twitterTriggers.add(twitterTrigger1);
        Mockito.when((Object)this.twitterConsumerService.getMentionEvents((TwitterAccount)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyString())).thenReturn(twitterTriggers);
        TwitterAccount twitterAccount = this.twitterService.addTwitterAccount("twitterUsername", ADMIN_USER);
        Assert.assertThrows(IllegalAccessException.class, () -> this.twitterService.getTwitterAccounts(USER, 0, 10, true));
        TwitterServiceTest.assertNotNull((Object)this.twitterService.getTwitterAccounts(ADMIN_USER, 0, 10, true));
        Assert.assertThrows(IllegalAccessException.class, () -> this.twitterService.countTwitterAccounts(USER));
        TwitterServiceTest.assertEquals((int)1, (int)this.twitterService.countTwitterAccounts(ADMIN_USER));
        TwitterServiceTest.assertEquals((long)1254555L, (long)this.twitterService.getTwitterAccountById(twitterAccount.getId()).getLastMentionTweetId());
        Assert.assertThrows(IllegalAccessException.class, () -> this.twitterService.getTwitterAccountById(twitterAccount.getId(), USER));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.twitterService.getTwitterAccountById(-10L));
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.twitterService.getTwitterAccountById(10L, ADMIN_USER));
        TwitterServiceTest.assertNotNull((Object)this.twitterService.getTwitterAccountById(twitterAccount.getId(), ADMIN_USER));
        TwitterAccount twitterAccount1 = this.twitterService.addTwitterAccount("twitterUsername1", ADMIN_USER);
        Throwable exception1 = Assert.assertThrows(IllegalStateException.class, () -> this.twitterService.addTwitterAccount("twitterUsername2", ADMIN_USER));
        TwitterServiceTest.assertEquals((String)"The maximum number of watched twitter accounts has been reached", (String)exception1.getMessage());
        this.twitterService.deleteTwitterAccount(twitterAccount1.getId(), ADMIN_USER);
        Assert.assertThrows(ObjectAlreadyExistsException.class, () -> this.twitterService.addTwitterAccount("twitterUsername", ADMIN_USER));
        this.twitterService.updateAccountLastMentionTweetId(twitterAccount.getId(), 111122222L);
        TwitterServiceTest.assertEquals((long)111122222L, (long)this.twitterService.getTwitterAccountById(twitterAccount.getId()).getLastMentionTweetId());
        Assert.assertThrows(IllegalArgumentException.class, () -> this.twitterService.updateAccountLastMentionTweetId(-10L, 111122222L));
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.twitterService.updateAccountLastMentionTweetId(10L, 111122222L));
    }

    @Test
    public void testDeleteTwitterAccount() throws Exception {
        this.twitterService.saveTwitterBearerToken("bearerToken", ADMIN_USER);
        RemoteTwitterAccount remoteTwitterAccount = new RemoteTwitterAccount(1L, "username", "name", "description", "avatarUrl");
        Mockito.when((Object)this.twitterConsumerService.retrieveTwitterAccount("twitterUsername", "bearerToken")).thenReturn((Object)remoteTwitterAccount);
        TwitterAccount twitterAccount = this.twitterService.addTwitterAccount("twitterUsername", ADMIN_USER);
        Assert.assertThrows(IllegalAccessException.class, () -> this.twitterService.deleteTwitterAccount(twitterAccount.getId(), USER));
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.twitterService.deleteTwitterAccount(10L, ADMIN_USER));
        this.twitterService.deleteTwitterAccount(twitterAccount.getId(), ADMIN_USER);
        TwitterServiceTest.assertNull((Object)this.twitterService.getTwitterAccountById(twitterAccount.getId()));
    }

    @Test
    public void testSaveTwitterBearerToken() throws IllegalAccessException {
        Assert.assertThrows(IllegalAccessException.class, () -> this.twitterService.saveTwitterBearerToken("bearerToken", USER));
        this.twitterService.saveTwitterBearerToken("bearerToken", ADMIN_USER);
        Assert.assertThrows(IllegalAccessException.class, () -> this.twitterService.getTwitterBearerToken(USER));
        TwitterServiceTest.assertNotNull((Object)this.twitterService.getTwitterBearerToken(ADMIN_USER));
        Assert.assertThrows(IllegalAccessException.class, () -> this.twitterService.deleteTwitterBearerToken(USER));
        this.twitterService.deleteTwitterBearerToken(ADMIN_USER);
        TwitterServiceTest.assertNull((Object)this.twitterService.getTwitterBearerToken());
    }

    @Test
    public void testAddTweetToWatch() throws Exception {
        Set tweetLikers = Tools.toSet((Object[])new String[]{"user1", "user2", "user3"});
        Set tweetRetweeters = Tools.toSet((Object[])new String[]{"user1", "user2"});
        this.twitterService.saveTwitterBearerToken("bearerToken", ADMIN_USER);
        Mockito.when((Object)this.twitterConsumerService.retrieveTweetLikers("tweetLink", "bearerToken")).thenReturn((Object)tweetLikers);
        Mockito.when((Object)this.twitterConsumerService.retrieveTweetRetweeters("tweetLink", "bearerToken")).thenReturn((Object)tweetRetweeters);
        Tweet tweet = this.twitterService.addTweetToWatch("tweetLink");
        TwitterServiceTest.assertEquals((int)1, (int)this.twitterService.getTweets(0, 10).size());
        Assert.assertThrows(IllegalArgumentException.class, () -> this.twitterService.getTweetByLink(null));
        TwitterServiceTest.assertNotNull((Object)this.twitterService.getTweetByLink("tweetLink"));
        this.twitterService.addTweetToWatch("tweetLink");
        TwitterServiceTest.assertEquals((int)1, (int)this.twitterService.getTweets(0, 10).size());
        this.twitterService.deleteTweet(tweet.getTweetId());
        TwitterServiceTest.assertEquals((int)0, (int)this.twitterService.getTweets(0, 10).size());
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.twitterService.deleteTweet(-10L));
        tweet = this.twitterService.addTweetToWatch("tweetLink");
        tweetLikers = Tools.toSet((Object[])new String[]{"user1", "user2", "user3", "user4"});
        tweetRetweeters = Tools.toSet((Object[])new String[]{"user1", "user2", "user3"});
        this.twitterService.updateTweetReactions(tweet.getTweetId(), tweetLikers, tweetRetweeters);
        TwitterServiceTest.assertEquals((Object)tweetLikers, (Object)this.twitterService.getTweetByLink(tweet.getTweetLink()).getLikers());
        TwitterServiceTest.assertEquals((Object)tweetRetweeters, (Object)this.twitterService.getTweetByLink(tweet.getTweetLink()).getRetweeters());
        Assert.assertThrows(IllegalArgumentException.class, () -> this.twitterService.updateTweetReactions(-10L, null, null));
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.twitterService.updateTweetReactions(10L, null, null));
    }
}

