/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.twitter.storage;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.meeds.gamification.twitter.exception.TwitterConnectionException;
import io.meeds.gamification.twitter.model.RemoteTwitterAccount;
import io.meeds.gamification.twitter.model.TokenStatus;
import io.meeds.gamification.twitter.model.TwitterAccount;
import io.meeds.gamification.twitter.model.TwitterTrigger;
import io.meeds.gamification.twitter.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class TwitterConsumerStorage {
    private static final Log LOG = ExoLogger.getLogger(TwitterConsumerStorage.class);
    public static final String TWITTER_API_URL = "https://api.twitter.com/2";
    public static final String BEARER = "Bearer ";
    public static final String AUTHORIZATION = "Authorization";
    public static final String TWITTER_CONNECTION_ERROR = "twitter.connectionError";
    public static final String TWITTER_RETRIEVE_ACCOUNT_ERROR = "Unable to retrieve info for Twitter account with identifier {}.";
    public static final String TWITTER_RETRIEVE_ACCOUNT_MENTIONS_ERROR = "Unable to retrieve mentions for Twitter account with id {}.";
    public static final String TWITTER_RETRIEVE_TWEET_LIKERS_ERROR = "Unable to retrieve likers for Tweet with id {}.";
    public static final String TWITTER_RETRIEVE_TWEET_RETWEETERS_ERROR = "Unable to retrieve retweeters for Tweet with id {}.";
    public static final String USERNAME = "username";
    public static final String USERS = "users";
    private HttpClient client;

    public RemoteTwitterAccount retrieveTwitterAccount(String twitterUsername, String bearerToken) throws ObjectNotFoundException {
        String response;
        URI uri = URI.create("https://api.twitter.com/2/users/by/username/" + twitterUsername + "?user.fields=profile_image_url");
        try {
            response = this.processGet(uri, bearerToken);
        }
        catch (TwitterConnectionException e) {
            LOG.warn(TWITTER_RETRIEVE_ACCOUNT_ERROR, new Object[]{twitterUsername});
            return null;
        }
        if (response == null) {
            throw new ObjectNotFoundException("twitter.accountNotFound");
        }
        Map<String, Object> resultMap = this.fromJsonStringToMap(response);
        RemoteTwitterAccount remoteTwitterAccount = new RemoteTwitterAccount();
        remoteTwitterAccount.setId(Long.parseLong(Objects.requireNonNull(this.extractSubItem(resultMap, "data", "id"))));
        remoteTwitterAccount.setName(this.extractSubItem(resultMap, "data", "name"));
        remoteTwitterAccount.setUsername(this.extractSubItem(resultMap, "data", USERNAME));
        remoteTwitterAccount.setDescription(this.extractSubItem(resultMap, "data", "description"));
        remoteTwitterAccount.setAvatarUrl(this.extractSubItem(resultMap, "data", "profile_image_url"));
        return remoteTwitterAccount;
    }

    public RemoteTwitterAccount retrieveTwitterAccount(long twitterRemoteId, String bearerToken) {
        String response;
        URI uri = URI.create("https://api.twitter.com/2/users/" + twitterRemoteId + "?user.fields=profile_image_url,description");
        try {
            response = this.processGet(uri, bearerToken);
        }
        catch (TwitterConnectionException e) {
            LOG.warn(TWITTER_RETRIEVE_ACCOUNT_ERROR, new Object[]{twitterRemoteId});
            return null;
        }
        if (response == null) {
            return null;
        }
        Map<String, Object> resultMap = this.fromJsonStringToMap(response);
        RemoteTwitterAccount remoteTwitterAccount = new RemoteTwitterAccount();
        remoteTwitterAccount.setId(Long.parseLong(Objects.requireNonNull(this.extractSubItem(resultMap, "data", "id"))));
        remoteTwitterAccount.setName(this.extractSubItem(resultMap, "data", "name"));
        remoteTwitterAccount.setUsername(this.extractSubItem(resultMap, "data", USERNAME));
        remoteTwitterAccount.setDescription(this.extractSubItem(resultMap, "data", "description"));
        remoteTwitterAccount.setAvatarUrl(this.extractSubItem(resultMap, "data", "profile_image_url"));
        return remoteTwitterAccount;
    }

    public List<TwitterTrigger> getMentionEvents(TwitterAccount twitterAccount, long lastMentionTweetId, String bearerToken) {
        String response;
        StringBuilder builder = new StringBuilder(TWITTER_API_URL);
        builder.append("/users/");
        builder.append(twitterAccount.getRemoteId());
        builder.append("/mentions?tweet.fields=conversation_id&expansions=author_id,entities.mentions.username&max_results=100");
        if (lastMentionTweetId > 0L) {
            builder.append("&since_id=");
            builder.append(lastMentionTweetId);
        }
        URI uri = URI.create(builder.toString());
        try {
            response = this.processGet(uri, bearerToken);
        }
        catch (TwitterConnectionException e) {
            LOG.warn(TWITTER_RETRIEVE_ACCOUNT_MENTIONS_ERROR, new Object[]{twitterAccount.getRemoteId()});
            return Collections.emptyList();
        }
        if (response == null) {
            return Collections.emptyList();
        }
        JsonNode rootNode = this.fromJsonStringToJsonNode(response);
        JsonNode usersNode = rootNode.path("includes").path(USERS);
        JsonNode dataNodes = rootNode.path("data");
        ArrayList<TwitterTrigger> twitterEvents = new ArrayList<TwitterTrigger>();
        for (JsonNode dataNode : dataNodes) {
            long tweetId = dataNode.path("id").asLong();
            long parentTweetId = dataNode.path("conversation_id").asLong();
            String text = dataNode.path("text").asText();
            if (tweetId != parentTweetId) {
                Pattern pattern = Pattern.compile("@" + twitterAccount.getIdentifier());
                Matcher matcher = pattern.matcher(text);
                int count = 0;
                while (matcher.find()) {
                    ++count;
                }
                if (count <= 1) continue;
            }
            long userId = dataNode.path("author_id").asLong();
            String username = null;
            for (JsonNode userNode : usersNode) {
                if (!userNode.has("id") || userNode.get("id").asLong() != userId) continue;
                username = userNode.path(USERNAME).asText();
                break;
            }
            TwitterTrigger twitterEvent = new TwitterTrigger("mentionAccount", username, tweetId, "tweet", twitterAccount.getRemoteId());
            twitterEvents.add(twitterEvent);
        }
        return twitterEvents;
    }

    public Set<String> retrieveTweetLikers(String tweetLink, String bearerToken) {
        String tweetId = Utils.extractTweetId(tweetLink);
        if (StringUtils.isNotBlank((CharSequence)tweetId)) {
            String response;
            String builder = "https://api.twitter.com/2/tweets/" + tweetId + "/liking_users";
            URI uri = URI.create(builder);
            try {
                response = this.processGet(uri, bearerToken);
            }
            catch (TwitterConnectionException e) {
                LOG.warn(TWITTER_RETRIEVE_TWEET_LIKERS_ERROR, new Object[]{tweetId});
                return Collections.emptySet();
            }
            if (response == null) {
                return Collections.emptySet();
            }
            JsonNode rootNode = this.fromJsonStringToJsonNode(response);
            JsonNode dataNodes = rootNode.path("data");
            HashSet<String> likers = new HashSet<String>();
            for (JsonNode dataNode : dataNodes) {
                String username = dataNode.path(USERNAME).asText();
                likers.add(username);
            }
            return likers;
        }
        return Collections.emptySet();
    }

    public Set<String> retrieveTweetRetweeters(String tweetLink, String bearerToken) {
        String tweetId = Utils.extractTweetId(tweetLink);
        if (StringUtils.isNotBlank((CharSequence)tweetId)) {
            String response;
            String builder = "https://api.twitter.com/2/tweets/" + tweetId + "/retweeted_by";
            URI uri = URI.create(builder);
            try {
                response = this.processGet(uri, bearerToken);
            }
            catch (TwitterConnectionException e) {
                LOG.warn(TWITTER_RETRIEVE_TWEET_RETWEETERS_ERROR, new Object[]{tweetId});
                return Collections.emptySet();
            }
            if (response == null) {
                return Collections.emptySet();
            }
            JsonNode rootNode = this.fromJsonStringToJsonNode(response);
            JsonNode dataNodes = rootNode.path("data");
            HashSet<String> retweeters = new HashSet<String>();
            for (JsonNode dataNode : dataNodes) {
                String username = dataNode.path(USERNAME).asText();
                retweeters.add(username);
            }
            return retweeters;
        }
        return Collections.emptySet();
    }

    public TokenStatus checkTwitterTokenStatus(String bearerToken) {
        TokenStatus tokenStatus = new TokenStatus();
        if (StringUtils.isBlank((CharSequence)bearerToken)) {
            return tokenStatus;
        }
        URI uri = URI.create("https://api.twitter.com/1.1/application/rate_limit_status.json?resources=users");
        HttpClient httpClient = this.getHttpClient();
        HttpGet request = new HttpGet(uri);
        request.setHeader(AUTHORIZATION, BEARER + bearerToken);
        try {
            boolean isSuccess;
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)request);
            boolean bl = isSuccess = httpResponse != null && httpResponse.getStatusLine().getStatusCode() >= 200 && httpResponse.getStatusLine().getStatusCode() < 300;
            if (isSuccess) {
                String response = this.processSuccessResponse(httpResponse);
                Map<String, Object> resultMap = this.fromJsonStringToMap(response);
                String remaining = this.extractSubItem(resultMap, "resources", USERS, "/users/by/username/:username", "remaining");
                String reset = this.extractSubItem(resultMap, "resources", USERS, "/users/by/username/:username", "reset");
                tokenStatus.setIsValid(true);
                if (StringUtils.isNotBlank((CharSequence)remaining)) {
                    tokenStatus.setRemaining(Long.parseLong(remaining));
                }
                if (StringUtils.isNotBlank((CharSequence)reset)) {
                    tokenStatus.setReset(Long.parseLong(reset));
                }
                return tokenStatus;
            }
            if (httpResponse != null && (httpResponse.getStatusLine().getStatusCode() == 401 || httpResponse.getStatusLine().getStatusCode() == 403)) {
                return new TokenStatus(false, null, null);
            }
            return null;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to retrieve Twitter bearer token status", e);
        }
    }

    private String processGet(URI uri, String bearerToken) throws TwitterConnectionException {
        HttpClient httpClient = this.getHttpClient();
        HttpGet request = new HttpGet(uri);
        try {
            request.setHeader(AUTHORIZATION, BEARER + bearerToken);
            return this.processRequest(httpClient, (HttpRequestBase)request);
        }
        catch (IOException e) {
            throw new TwitterConnectionException(TWITTER_CONNECTION_ERROR, e);
        }
    }

    private String processRequest(HttpClient httpClient, HttpRequestBase request) throws IOException, TwitterConnectionException {
        boolean isSuccess;
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        boolean bl = isSuccess = response != null && response.getStatusLine().getStatusCode() >= 200 && response.getStatusLine().getStatusCode() < 300;
        if (isSuccess) {
            return this.processSuccessResponse(response);
        }
        if (response != null && response.getStatusLine().getStatusCode() == 404) {
            return null;
        }
        this.processErrorResponse(response);
        return null;
    }

    private String processSuccessResponse(HttpResponse response) throws IOException {
        if (response.getStatusLine().getStatusCode() == 204) {
            return String.valueOf(204);
        }
        if ((response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 200) && response.getEntity() != null && response.getEntity().getContentLength() != 0L) {
            try (InputStream is = response.getEntity().getContent();){
                String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                return string;
            }
        }
        return null;
    }

    private void processErrorResponse(HttpResponse response) throws TwitterConnectionException, IOException {
        if (response == null) {
            throw new TwitterConnectionException("Error when connecting twitter");
        }
        if (response.getEntity() != null) {
            InputStream is = response.getEntity().getContent();
            try {
                String errorMessage = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                if (StringUtils.contains((CharSequence)errorMessage, (CharSequence)"")) {
                    throw new TwitterConnectionException(errorMessage);
                }
                throw new TwitterConnectionException(TWITTER_CONNECTION_ERROR + errorMessage);
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        throw new TwitterConnectionException(TWITTER_CONNECTION_ERROR + response.getStatusLine().getStatusCode());
    }

    private HttpClient getHttpClient() {
        if (this.client == null) {
            RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("standard").build();
            HttpClientConnectionManager clientConnectionManager = this.getClientConnectionManager();
            HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultRequestConfig(requestConfig).setDefaultCookieStore((CookieStore)new BasicCookieStore()).setConnectionManager(clientConnectionManager).setConnectionReuseStrategy((ConnectionReuseStrategy)new DefaultConnectionReuseStrategy());
            this.client = httpClientBuilder.build();
        }
        return this.client;
    }

    private HttpClientConnectionManager getClientConnectionManager() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(10);
        return connectionManager;
    }

    public void clearCache() {
    }

    public void clearCache(TwitterAccount twitterAccount, String bearerToken) {
    }

    private Map<String, Object> fromJsonStringToMap(String jsonString) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return (Map)objectMapper.readValue(jsonString, Map.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error converting JSON string to map: " + jsonString, e);
        }
    }

    private JsonNode fromJsonStringToJsonNode(String jsonString) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.readTree(jsonString);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error converting JSON string to JsonNode: " + jsonString, e);
        }
    }

    private String extractSubItem(Map<String, Object> map, String ... keys) {
        Object currentObject = map;
        for (String key : keys) {
            if (!(currentObject instanceof Map)) {
                return null;
            }
            currentObject = currentObject.get(key);
        }
        return currentObject != null ? currentObject.toString() : null;
    }
}

