/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.twitter.web;

import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.github.scribejava.core.pkce.PKCE;
import com.github.scribejava.core.pkce.PKCECodeChallengeMethod;
import io.meeds.gamification.model.RemoteConnectorSettings;
import io.meeds.gamification.service.ConnectorSettingService;
import io.meeds.gamification.twitter.model.TwitterOAuth20Api;
import io.meeds.oauth.exception.OAuthException;
import io.meeds.oauth.exception.OAuthExceptionCode;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.filter.Filter;

public class TwitterConnectorFilter
implements Filter {
    private static final Log LOG = ExoLogger.getLogger(TwitterConnectorFilter.class);
    private OAuth20Service oAuthService;
    private long remoteConnectorId;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
        ConnectorSettingService connectorSettingService = (ConnectorSettingService)CommonsUtils.getService(ConnectorSettingService.class);
        RemoteConnectorSettings remoteConnectorSettings = connectorSettingService.getConnectorSettings("twitter");
        remoteConnectorSettings.setSecretKey(connectorSettingService.getConnectorSecretKey("twitter"));
        if (StringUtils.isBlank((CharSequence)remoteConnectorSettings.getApiKey()) || StringUtils.isBlank((CharSequence)remoteConnectorSettings.getSecretKey())) {
            LOG.warn("Missing '{}' connector settings", new Object[]{"twitter"});
            return;
        }
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            String secretState = "state";
            PKCE pkce = new PKCE();
            pkce.setCodeChallenge("challenge");
            pkce.setCodeChallengeMethod(PKCECodeChallengeMethod.PLAIN);
            pkce.setCodeVerifier("challenge");
            String authorizationUrl = this.getOAuthService(remoteConnectorSettings).createAuthorizationUrlBuilder().pkce(pkce).state(secretState).build();
            if (StringUtils.isNotBlank((CharSequence)authorizationUrl)) {
                httpResponse.sendRedirect(authorizationUrl);
            }
        }
        catch (IOException e) {
            throw new OAuthException(OAuthExceptionCode.IO_ERROR, (Throwable)e);
        }
    }

    private OAuth20Service getOAuthService(RemoteConnectorSettings remoteConnectorSettings) {
        if (this.oAuthService == null || (long)remoteConnectorSettings.hashCode() != this.remoteConnectorId) {
            this.remoteConnectorId = remoteConnectorSettings.hashCode();
            this.oAuthService = new ServiceBuilder(remoteConnectorSettings.getApiKey()).apiSecret(remoteConnectorSettings.getSecretKey()).callback(remoteConnectorSettings.getRedirectUrl()).defaultScope("users.read tweet.read").build((DefaultApi20)TwitterOAuth20Api.instance());
        }
        return this.oAuthService;
    }
}

