/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.twitter.gamification.storage;

import io.meeds.twitter.gamification.dao.TwitterTweetDAO;
import io.meeds.twitter.gamification.entity.TwitterTweetEntity;
import io.meeds.twitter.gamification.model.Tweet;
import io.meeds.twitter.gamification.storage.TwitterTweetStorage;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.gatein.common.util.Tools;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

@SpringBootTest(classes={TwitterTweetStorage.class})
@ExtendWith(value={MockitoExtension.class})
class TwitterTweetStorageTest {
    private static final Long ID = 2L;
    private static final String TWEET_LINK = "tweetLink";
    private static final Pageable PAGEABLE = Pageable.ofSize((int)2);
    @Autowired
    private TwitterTweetStorage twitterTweetStorage;
    @MockBean
    private TwitterTweetDAO twitterTweetDAO;

    TwitterTweetStorageTest() {
    }

    @BeforeEach
    void setup() {
        Mockito.when((Object)this.twitterTweetDAO.save((Object)((TwitterTweetEntity)Mockito.any()))).thenAnswer(invocation -> {
            TwitterTweetEntity entity = (TwitterTweetEntity)invocation.getArgument(0);
            if (entity.getId() == null) {
                entity.setId(ID);
            }
            Mockito.when((Object)this.twitterTweetDAO.findById((Object)ID)).thenReturn(Optional.of(entity));
            Mockito.when((Object)this.twitterTweetDAO.findTwitterTweetEntityByTweetLink(TWEET_LINK)).thenReturn((Object)entity);
            Mockito.when((Object)this.twitterTweetDAO.findAll(PAGEABLE)).thenReturn((Object)new PageImpl(List.of(entity)));
            Mockito.when((Object)this.twitterTweetDAO.count()).thenReturn((Object)1L);
            return entity;
        });
        ((TwitterTweetDAO)Mockito.doAnswer(invocation -> {
            TwitterTweetEntity entity = (TwitterTweetEntity)invocation.getArgument(0);
            Mockito.when((Object)this.twitterTweetDAO.findById((Object)entity.getId())).thenReturn(Optional.empty());
            return null;
        }).when((Object)this.twitterTweetDAO)).delete((Object)((TwitterTweetEntity)Mockito.any()));
    }

    @Test
    void testAddTweetToWatch() {
        Tweet tweet = this.createTwitterTweetInstance();
        Tweet createdTweet = this.twitterTweetStorage.addTweetToWatch(tweet);
        Assertions.assertNotNull((Object)createdTweet);
        Assertions.assertEquals((Object)tweet.getTweetLink(), (Object)createdTweet.getTweetLink());
        createdTweet = this.twitterTweetStorage.addTweetToWatch(tweet);
        Assertions.assertNull((Object)createdTweet);
    }

    @Test
    void testGetTweetById() {
        Tweet createdTweet = this.twitterTweetStorage.addTweetToWatch(this.createTwitterTweetInstance());
        Tweet tweet = this.twitterTweetStorage.getTweetById(Long.valueOf(createdTweet.getTweetId()));
        Assertions.assertNotNull((Object)tweet);
        Assertions.assertEquals((Object)createdTweet.getTweetLink(), (Object)tweet.getTweetLink());
    }

    @Test
    void testGetTweets() {
        Tweet tweet = this.createTwitterTweetInstance();
        Tweet createdTweet = this.twitterTweetStorage.addTweetToWatch(tweet);
        Assertions.assertNotNull((Object)createdTweet);
        Assertions.assertEquals((Object)new PageImpl(List.of(createdTweet)), (Object)this.twitterTweetStorage.getTweets(PAGEABLE));
        Assertions.assertEquals((long)1L, (long)this.twitterTweetStorage.countTweets());
    }

    @Test
    void testTweetReactions() {
        Tweet TwitterTweet = this.createTwitterTweetInstance();
        Set tweetLikers = Tools.toSet((Object[])new String[]{"user1", "user2", "user3"});
        Set tweetRetweeters = Tools.toSet((Object[])new String[]{"user1", "user2"});
        Tweet tweet = this.twitterTweetStorage.updateTweetReactions(10L, tweetLikers, tweetRetweeters);
        Assertions.assertNull((Object)tweet);
        Tweet createdTweet = this.twitterTweetStorage.addTweetToWatch(TwitterTweet);
        tweet = this.twitterTweetStorage.updateTweetReactions(createdTweet.getTweetId(), tweetLikers, tweetRetweeters);
        Assertions.assertNotNull((Object)tweet);
        Assertions.assertEquals((Object)createdTweet.getTweetLink(), (Object)tweet.getTweetLink());
        Assertions.assertEquals((Object)tweetLikers, (Object)tweet.getLikers());
        Assertions.assertEquals((Object)tweetRetweeters, (Object)tweet.getRetweeters());
    }

    @Test
    void testDeleteWebHook() {
        Tweet createdTweet = this.twitterTweetStorage.addTweetToWatch(this.createTwitterTweetInstance());
        Tweet tweet = this.twitterTweetStorage.deleteTweet(createdTweet.getTweetId());
        Assertions.assertNotNull((Object)tweet);
    }

    @Test
    void testGetTwitterAccountByRemoteId() {
        Tweet createdTweet = this.twitterTweetStorage.addTweetToWatch(this.createTwitterTweetInstance());
        Tweet tweet = this.twitterTweetStorage.getTweetByLink(createdTweet.getTweetLink());
        Assertions.assertNotNull((Object)tweet);
        Assertions.assertEquals((Object)createdTweet.getTweetLink(), (Object)tweet.getTweetLink());
    }

    protected Tweet createTwitterTweetInstance() {
        Tweet tweet = new Tweet();
        tweet.setTweetLink(TWEET_LINK);
        return tweet;
    }
}

