/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.twitter.gamification.storage.mapper;

import io.meeds.twitter.gamification.entity.TwitterTweetEntity;
import io.meeds.twitter.gamification.model.Tweet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TwitterTweetMapper {
    private TwitterTweetMapper() {
    }

    public static TwitterTweetEntity toEntity(Tweet tweet) {
        if (tweet == null) {
            return null;
        }
        TwitterTweetEntity twitterTweetEntity = new TwitterTweetEntity();
        if (tweet.getTweetId() > 0L) {
            twitterTweetEntity.setId(tweet.getTweetId());
        }
        if (StringUtils.isNotBlank((CharSequence)tweet.getTweetLink())) {
            twitterTweetEntity.setTweetLink(tweet.getTweetLink());
        }
        if (CollectionUtils.isNotEmpty(tweet.getLikers())) {
            twitterTweetEntity.setLikers(tweet.getLikers());
        }
        if (CollectionUtils.isNotEmpty(tweet.getRetweeters())) {
            twitterTweetEntity.setRetweeters(tweet.getRetweeters());
        }
        return twitterTweetEntity;
    }

    public static Tweet fromEntity(TwitterTweetEntity twitterTweetEntity) {
        if (twitterTweetEntity == null) {
            return null;
        }
        return new Tweet(twitterTweetEntity.getId(), twitterTweetEntity.getTweetLink(), twitterTweetEntity.getLikers(), twitterTweetEntity.getRetweeters());
    }
}

