/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.twitter.gamification.service;

import io.meeds.gamification.model.EventDTO;
import io.meeds.gamification.service.ConnectorService;
import io.meeds.gamification.service.EventService;
import io.meeds.gamification.service.TriggerService;
import io.meeds.twitter.gamification.model.TwitterTrigger;
import io.meeds.twitter.gamification.service.TwitterTriggerService;
import io.meeds.twitter.gamification.service.impl.TwitterTriggerServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@SpringBootTest(classes={TwitterTriggerServiceImpl.class})
class TwitterTriggerServiceTest {
    private static final String USER = "root";
    @MockBean
    private ConnectorService connectorService;
    @MockBean
    private EventService eventService;
    @MockBean
    private TriggerService triggerService;
    @MockBean
    private IdentityManager identityManager;
    @MockBean
    private ListenerService listenerService;
    @MockBean
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private TwitterTriggerService twitterTriggerService;

    TwitterTriggerServiceTest() {
    }

    @Test
    void testHandleTriggerAsync() throws Exception {
        TwitterTrigger twitterTrigger = new TwitterTrigger();
        twitterTrigger.setType("tweet");
        twitterTrigger.setTrigger("likeTweet");
        twitterTrigger.setTwitterUsername("liker");
        twitterTrigger.setTweetId(11112222L);
        Mockito.when((Object)this.triggerService.isTriggerEnabledForAccount(twitterTrigger.getTrigger(), twitterTrigger.getAccountId())).thenReturn((Object)true);
        Mockito.when((Object)this.connectorService.getAssociatedUsername("twitter", twitterTrigger.getTwitterUsername())).thenReturn((Object)USER);
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(USER)).thenReturn((Object)identity);
        ArrayList<EventDTO> events = new ArrayList<EventDTO>();
        EventDTO eventDTO = new EventDTO(1L, "likeTweet", "twitter", "likeTweet", null, null);
        EventDTO eventDTO1 = new EventDTO(2L, "likeTweet", "twitter", "likeTweet", null, null);
        events.add(eventDTO);
        events.add(eventDTO1);
        Mockito.when((Object)this.eventService.getEventsByTitle(twitterTrigger.getTrigger(), 0, -1)).thenReturn(events);
        this.twitterTriggerService.handleTriggerAsyncInternal(twitterTrigger);
        String eventDetails = "{accountId: " + twitterTrigger.getAccountId() + ", tweetId: " + twitterTrigger.getTweetId() + "}";
        HashMap<String, Object> gam = new HashMap<String, Object>();
        gam.put("senderId", USER);
        gam.put("receiverId", USER);
        gam.put("objectId", "11112222");
        gam.put("objectType", "tweet");
        gam.put("ruleTitle", "likeTweet");
        gam.put("eventDetails", eventDetails);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("exo.gamification.generic.action", gam, (Object)"");
    }
}

