/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import org.apache.poi.ss.formula.BaseFormulaEvaluator;
import org.apache.poi.ss.formula.EvaluationCell;
import org.apache.poi.ss.formula.EvaluationWorkbook;
import org.apache.poi.ss.formula.WorkbookEvaluator;
import org.apache.poi.ss.formula.eval.BoolEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.ptg.Area3DPxg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.model.ExternalLinksTable;
import org.apache.poi.xssf.usermodel.BaseXSSFEvaluationWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFEvaluationCell;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public abstract class BaseXSSFFormulaEvaluator
extends BaseFormulaEvaluator {
    protected BaseXSSFFormulaEvaluator(WorkbookEvaluator bookEvaluator) {
        super(bookEvaluator);
    }

    protected RichTextString createRichTextString(String str) {
        return new XSSFRichTextString(str);
    }

    protected abstract EvaluationCell toEvaluationCell(Cell var1);

    protected CellValue evaluateFormulaCellValue(Cell cell) {
        NumberEval ne;
        ValueEval eval;
        try {
            EvaluationCell evalCell = this.toEvaluationCell(cell);
            eval = this._bookEvaluator.evaluate(evalCell);
            if (evalCell instanceof XSSFEvaluationCell) {
                this.cacheExternalWorkbookCells((XSSFEvaluationCell)evalCell);
            }
        }
        catch (IllegalStateException e) {
            if (e.getClass() == IllegalStateException.class) {
                throw new IllegalStateException("Failed to evaluate cell: " + new CellReference(cell.getSheet().getSheetName(), cell.getRowIndex(), cell.getColumnIndex(), false, false).formatAsString(true) + ", value: " + cell, e);
            }
            throw e;
        }
        if (eval instanceof NumberEval) {
            ne = (NumberEval)eval;
            return new CellValue(ne.getNumberValue());
        }
        if (eval instanceof BoolEval) {
            BoolEval be = (BoolEval)eval;
            return CellValue.valueOf((boolean)be.getBooleanValue());
        }
        if (eval instanceof StringEval) {
            ne = (StringEval)eval;
            return new CellValue(ne.getStringValue());
        }
        if (eval instanceof ErrorEval) {
            return CellValue.getError((int)((ErrorEval)eval).getErrorCode());
        }
        throw new IllegalStateException("Unexpected eval class (" + eval.getClass().getName() + "): " + eval + ", cell: " + new CellReference(cell.getSheet().getSheetName(), cell.getRowIndex(), cell.getColumnIndex(), false, false).formatAsString(true) + ", value: " + cell);
    }

    private void cacheExternalWorkbookCells(XSSFEvaluationCell evalCell) {
        Ptg[] formulaTokens;
        for (Ptg ptg : formulaTokens = this.getEvaluationWorkbook().getFormulaTokens((EvaluationCell)evalCell)) {
            EvaluationWorkbook.ExternalSheet externalSheet;
            Area3DPxg area3DPxg;
            if (!(ptg instanceof Area3DPxg) || (area3DPxg = (Area3DPxg)ptg).getExternalWorkbookNumber() <= 0 || (externalSheet = this.getEvaluationWorkbook().getExternalSheet(area3DPxg.getSheetName(), area3DPxg.getLastSheetName(), area3DPxg.getExternalWorkbookNumber())) == null) continue;
            BaseXSSFFormulaEvaluator.processEvalCell(evalCell, externalSheet, area3DPxg);
        }
    }

    private static void processEvalCell(XSSFEvaluationCell evalCell, EvaluationWorkbook.ExternalSheet externalSheet, Area3DPxg area3DPxg) {
        XSSFCell xssfCell = evalCell.getXSSFCell();
        XSSFWorkbook xssfWorkbook = xssfCell.getSheet().getWorkbook();
        XSSFWorkbook externalWorkbook = (XSSFWorkbook)xssfWorkbook.getCreationHelper().getReferencedWorkbooks().get(externalSheet.getWorkbookName());
        ExternalLinksTable externalLinksTable = xssfWorkbook.getExternalLinksTable().get(area3DPxg.getExternalWorkbookNumber() - 1);
        if (externalWorkbook != null && externalLinksTable != null) {
            int firstSheet;
            int lastSheet = firstSheet = externalWorkbook.getSheetIndex(area3DPxg.getSheetName());
            if (area3DPxg.getLastSheetName() != null) {
                lastSheet = externalWorkbook.getSheetIndex(area3DPxg.getLastSheetName());
            }
            for (int sheetIndex = firstSheet; sheetIndex <= lastSheet; ++sheetIndex) {
                XSSFSheet sheet = externalWorkbook.getSheetAt(sheetIndex);
                int firstRow = area3DPxg.getFirstRow();
                int lastRow = area3DPxg.getLastRow();
                for (int rowIndex = firstRow; rowIndex <= lastRow; ++rowIndex) {
                    XSSFRow row = sheet.getRow(rowIndex);
                    if (row == null) continue;
                    int firstColumn = area3DPxg.getFirstColumn();
                    int lastColumn = area3DPxg.getLastColumn();
                    for (int cellIndex = firstColumn; cellIndex <= lastColumn; ++cellIndex) {
                        XSSFCell cell = row.getCell(cellIndex);
                        if (cell == null) continue;
                        String cellValue = cell.getRawValue();
                        String cellR = new CellReference((Cell)cell).formatAsString(false);
                        externalLinksTable.cacheData(sheet.getSheetName(), (long)rowIndex + 1L, cellR, cellValue);
                    }
                }
            }
        }
    }

    protected void setCellType(Cell cell, CellType cellType) {
        if (cell instanceof XSSFCell) {
            EvaluationWorkbook evaluationWorkbook = this.getEvaluationWorkbook();
            BaseXSSFEvaluationWorkbook xewb = BaseXSSFEvaluationWorkbook.class.isAssignableFrom(evaluationWorkbook.getClass()) ? (BaseXSSFEvaluationWorkbook)evaluationWorkbook : null;
            ((XSSFCell)cell).setCellType(cellType, xewb);
        } else {
            cell.setCellType(cellType);
        }
    }
}

