/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.notification.plugin;

import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.utils.Utils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class ContributionAcceptedNotificationPlugin
extends BaseNotificationPlugin {
    private final ActivityManager activityManager;

    public ContributionAcceptedNotificationPlugin(ActivityManager activityManager, InitParams initParams) {
        super(initParams);
        this.activityManager = activityManager;
    }

    public String getId() {
        return "GamificationContributionAcceptedNotification";
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        RealizationDTO realizationDTO = (RealizationDTO)ctx.value(Utils.REALIZATION_NOTIFICATION_PARAMETER);
        if (realizationDTO == null) {
            return null;
        }
        ExoSocialActivity activity = this.activityManager.getActivity(String.valueOf(realizationDTO.getActivityId()));
        if (activity == null) {
            return null;
        }
        return NotificationInfo.instance().to(realizationDTO.getCreatedBy()).with("REALIZATION_ID", String.valueOf(realizationDTO.getId())).with(SocialNotificationUtils.ACTIVITY_ID.getKey(), String.valueOf(realizationDTO.getActivityId())).key(this.getId()).end();
    }
}

