/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.storage;

import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.entity.ProgramEntity;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.model.filter.RealizationFilter;
import io.meeds.gamification.test.AbstractServiceTest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Test;

public class RealizationsStorageTest
extends AbstractServiceTest {
    @Test
    public void testFindAllRealizationsByFilter() {
        RealizationFilter filter = new RealizationFilter();
        List domainIds = Collections.emptyList();
        filter.setFromDate(this.fromDate);
        filter.setToDate(this.toDate);
        filter.setEarnerIds(new ArrayList());
        filter.setEarnerType(IdentityType.getType((String)""));
        filter.setProgramIds(domainIds);
        ProgramEntity domainEntity = this.newDomain();
        RealizationsStorageTest.assertEquals((int)0, (int)this.realizationsStorage.getRealizationsByFilter(filter, 0, 3).size());
        this.newRealizationEntity("rule", domainEntity.getId());
        this.newRealizationEntity("rule", domainEntity.getId());
        this.newRealizationEntity("rule", domainEntity.getId());
        RealizationsStorageTest.assertEquals((int)3, (int)this.realizationsStorage.getRealizationsByFilter(filter, 0, 3).size());
    }

    @Test
    public void testFindUsersRealizationsByFilter() {
        RealizationFilter filter = new RealizationFilter();
        List domainIds = Collections.emptyList();
        filter.setFromDate(this.fromDate);
        filter.setToDate(this.toDate);
        filter.setEarnerIds(new ArrayList<String>(Collections.singleton("1")));
        filter.setEarnerType(IdentityType.getType((String)""));
        filter.setProgramIds(domainIds);
        RealizationsStorageTest.assertEquals((int)0, (int)this.realizationsStorage.getRealizationsByFilter(filter, 0, 3).size());
        ProgramEntity domainEntity = this.newDomain();
        this.newRealizationEntity("rule", domainEntity.getId());
        this.newRealizationEntity("rule", domainEntity.getId());
        this.newRealizationEntity("rule", domainEntity.getId());
        RealizationsStorageTest.assertEquals((int)3, (int)this.realizationsStorage.getRealizationsByFilter(filter, 0, 3).size());
    }

    @Test
    public void testGetRealizationById() {
        RealizationFilter filter = new RealizationFilter();
        List domainIds = Collections.emptyList();
        filter.setFromDate(this.fromDate);
        filter.setToDate(this.toDate);
        filter.setEarnerIds(new ArrayList());
        filter.setEarnerType(IdentityType.getType((String)""));
        filter.setProgramIds(domainIds);
        RealizationsStorageTest.assertEquals((int)this.realizationsStorage.getRealizationsByFilter(filter, 0, 3).size(), (int)0);
        RealizationDTO gHistory = this.newRealizationDTO();
        RealizationDTO newGHistory = this.realizationsStorage.getRealizationById(gHistory.getId().longValue());
        RealizationsStorageTest.assertNotNull((Object)newGHistory);
        RealizationsStorageTest.assertEquals((String)gHistory.getActionTitle(), (String)newGHistory.getActionTitle());
    }

    @Test
    public void testUpdateRealizationStatus() {
        RealizationFilter filter = new RealizationFilter();
        List domainIds = Collections.emptyList();
        filter.setFromDate(this.fromDate);
        filter.setToDate(this.toDate);
        filter.setEarnerIds(new ArrayList());
        filter.setEarnerType(IdentityType.getType((String)""));
        filter.setProgramIds(domainIds);
        RealizationsStorageTest.assertEquals((int)this.realizationsStorage.getRealizationsByFilter(filter, 0, 3).size(), (int)0);
        RealizationDTO gHistory = this.newRealizationDTO();
        RealizationsStorageTest.assertEquals((String)gHistory.getStatus(), (String)RealizationStatus.ACCEPTED.name());
        gHistory.setStatus(RealizationStatus.REJECTED.name());
        RealizationDTO rejectedGHistory = this.realizationsStorage.updateRealization(gHistory);
        RealizationsStorageTest.assertEquals((String)rejectedGHistory.getStatus(), (String)RealizationStatus.REJECTED.name());
    }
}

