/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.plugin;

import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.test.AbstractServiceTest;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.junit.Assert;

public class ProgramTranslationPluginTest
extends AbstractServiceTest {
    private final Identity adminAclIdentity = new Identity("root1", Arrays.asList(new MembershipEntry("/platform/administrators")));
    private TranslationService translationService;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.identityRegistry.register(this.adminAclIdentity);
        this.translationService = (TranslationService)ExoContainerContext.getService(TranslationService.class);
    }

    public void testManageTranslations() throws IllegalAccessException, ObjectNotFoundException {
        ProgramDTO program = this.newProgram();
        ProgramTranslationPluginTest.assertNotNull((Object)program);
        long programId = program.getId();
        Assert.assertThrows(IllegalAccessException.class, () -> this.translationService.saveTranslationLabels("program", programId, "title", Collections.singletonMap(Locale.ENGLISH, "label"), "root2"));
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.translationService.saveTranslationLabels("program", 5555L, "title", Collections.singletonMap(Locale.ENGLISH, "label"), this.adminAclIdentity.getUserId()));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.saveTranslationLabels("program", 0L, "title", Collections.singletonMap(Locale.ENGLISH, "label"), "root2"));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.translationService.saveTranslationLabels("program", programId, null, Collections.singletonMap(Locale.ENGLISH, "label"), "root2"));
        Assert.assertThrows(IllegalAccessException.class, () -> this.translationService.saveTranslationLabels("program", programId, "title", Collections.singletonMap(Locale.ENGLISH, "label"), null));
        this.translationService.saveTranslationLabels("program", programId, "title", Collections.singletonMap(Locale.ENGLISH, "label"), this.adminAclIdentity.getUserId());
        TranslationField translationField = this.translationService.getTranslationField("program", programId, "title", this.adminAclIdentity.getUserId());
        ProgramTranslationPluginTest.assertNotNull((Object)translationField);
        ProgramTranslationPluginTest.assertEquals((long)programId, (long)translationField.getObjectId());
        ProgramTranslationPluginTest.assertEquals((String)"program", (String)translationField.getObjectType());
        ProgramTranslationPluginTest.assertEquals((String)((String)translationField.getLabels().get(Locale.ENGLISH)), (String)"label");
    }
}

