/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.mock;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class SpaceServiceMock
implements SpaceService {
    public static final String SPACE_PRETTY_NAME = "space150";
    public static final String SPACE_PRETTY_NAME2 = "space152";
    public static final String SPACE_GROUP_ID = "/spaces/space150";
    public static final String SPACE_DISPLAY_NAME = "test space";
    public static final String SPACE_ID_1 = "1";
    public static final String SPACE_ID_2 = "200";
    public static final List<String> SPACE_MEMBERS = Arrays.asList("root", "root10", "root5", "root1");
    public static final List<String> SPACE_MANAGERS = Arrays.asList("root", "root5", "root1");

    public Space getSpaceByPrettyName(String spacePrettyName) {
        if (SPACE_PRETTY_NAME.equals(spacePrettyName)) {
            return this.getSpace(SPACE_ID_1);
        }
        if (SPACE_PRETTY_NAME2.equals(spacePrettyName)) {
            return this.getSpace(SPACE_ID_2);
        }
        throw new UnsupportedOperationException(spacePrettyName);
    }

    public Space getSpaceByGroupId(String groupId) {
        if (groupId.equals(SPACE_GROUP_ID)) {
            return this.getSpace();
        }
        throw new UnsupportedOperationException(groupId);
    }

    public Space getSpaceById(String spaceId) {
        if (!SPACE_ID_1.equals(spaceId) && !SPACE_ID_2.equals(spaceId)) {
            return null;
        }
        return this.getSpace(spaceId);
    }

    public boolean isRedactor(Space space, String userId) {
        return StringUtils.equals((CharSequence)userId, (CharSequence)"root");
    }

    public boolean hasRedactor(Space space) {
        return SPACE_PRETTY_NAME.equals(space.getPrettyName());
    }

    public boolean canRedactOnSpace(Space space, Identity viewer) {
        if (viewer == null) {
            throw new IllegalStateException("User ACL Identity is mandatory");
        }
        return space != null && (!SPACE_PRETTY_NAME.equals(space.getPrettyName()) || SPACE_MANAGERS.contains(viewer.getUserId()));
    }

    public boolean canPublishOnSpace(Space space, String userId) {
        if (userId == null) {
            throw new IllegalStateException("User ACL Identity is mandatory");
        }
        return space != null && (!SPACE_PRETTY_NAME.equals(space.getPrettyName()) || SPACE_MANAGERS.contains(userId));
    }

    public boolean canViewSpace(Space space, String userId) {
        return this.isMember(space, userId);
    }

    public boolean isContentManager(String username) {
        return this.isSuperManager(username);
    }

    public boolean isContentPublisher(String username) {
        return this.isSuperManager(username);
    }

    public boolean isMember(Space space, String userId) {
        return space != null && SPACE_MEMBERS.contains(userId);
    }

    public boolean isManager(Space space, String userId) {
        return space != null && SPACE_MANAGERS.contains(userId);
    }

    public ListAccess<Space> getMemberSpaces(String username) {
        if (SPACE_MEMBERS.contains(username)) {
            return new ListAccessImpl(Space.class, Collections.singletonList(this.getSpace()));
        }
        return new ListAccessImpl(Space.class, Collections.emptyList());
    }

    public List<String> getMemberSpacesIds(String username, int offset, int limit) {
        if (SPACE_MEMBERS.contains(username)) {
            return Collections.singletonList(SPACE_ID_1);
        }
        return Collections.emptyList();
    }

    public List<String> getManagerSpacesIds(String username, int offset, int limit) {
        if (SPACE_MANAGERS.contains(username)) {
            return Collections.singletonList(SPACE_ID_1);
        }
        return Collections.emptyList();
    }

    public Space updateSpace(Space existingSpace) {
        String SpacePrettyName = existingSpace.getPrettyName();
        String description = "updateSpace";
        existingSpace.setPrettyName(existingSpace.getPrettyName());
        existingSpace.setDescription(description);
        existingSpace.setId(String.valueOf(SpacePrettyName.charAt(SpacePrettyName.length() - 1)));
        existingSpace.setGroupId("/spaces/" + SpacePrettyName);
        return existingSpace;
    }

    public boolean isSuperManager(String userId) {
        return "root".equals(userId);
    }

    public List<String> findExternalInvitationsSpacesByEmail(String email) {
        return Collections.emptyList();
    }

    public void deleteExternalUserInvitations(String email) {
    }

    private Space getSpace() {
        return this.getSpace(SPACE_ID_1);
    }

    private Space getSpace(String spaceId) {
        Space space = new Space();
        space.setId(spaceId);
        space.setPrettyName(SPACE_PRETTY_NAME);
        space.setDisplayName(SPACE_DISPLAY_NAME);
        space.setGroupId(SPACE_GROUP_ID);
        space.setManagers(new String[]{"root1"});
        space.setMembers(SPACE_MEMBERS.toArray(new String[0]));
        space.setRegistration(SPACE_ID_1.equals(spaceId) ? "validation" : "open");
        return space;
    }
}

