/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service;

import io.meeds.gamification.constant.EntityFilterType;
import io.meeds.gamification.constant.EntityStatusType;
import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.entity.ProgramEntity;
import io.meeds.gamification.model.ProgramColorAlreadyExists;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.filter.ProgramFilter;
import io.meeds.gamification.test.AbstractServiceTest;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.mock.MockUploadService;
import org.exoplatform.upload.UploadService;
import org.junit.Assert;
import org.junit.Test;

public class ProgramServiceTest
extends AbstractServiceTest {
    private static final String INTERNAL_USER = "internalUser";
    private static final String SPACE_MEMBER_USER = "root10";
    private static final String ADMIN_USER = "root1";
    private Identity adminAclIdentity;
    private Identity spaceMemberAclIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.adminAclIdentity = this.registerAdministratorUser(ADMIN_USER);
        this.spaceMemberAclIdentity = this.registerInternalUser(SPACE_MEMBER_USER);
        this.registerInternalUser(INTERNAL_USER);
    }

    @Test
    public void testGetProgramsAsAdmin() throws IllegalAccessException {
        ProgramFilter filter = new ProgramFilter();
        filter.setType(EntityFilterType.ALL);
        filter.setStatus(EntityStatusType.ENABLED);
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.getPrograms(filter, ADMIN_USER, 0, 10).size());
        this.newDomain(EntityType.MANUAL, "domain1", true, new HashSet<Long>());
        this.newDomain(EntityType.MANUAL, "domain2", true, new HashSet<Long>());
        this.newDomain(EntityType.AUTOMATIC, "domain3", true, new HashSet<Long>());
        this.newDomain(EntityType.AUTOMATIC, "domain4", true, new HashSet<Long>());
        ProgramServiceTest.assertEquals((int)4, (int)this.programService.getPrograms(filter, ADMIN_USER, 0, 10).size());
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramServiceTest.assertEquals((int)2, (int)this.programService.getPrograms(filter, ADMIN_USER, 0, 10).size());
        this.newDomain(EntityType.AUTOMATIC, "domain5", false, new HashSet<Long>());
        ProgramServiceTest.assertEquals((int)2, (int)this.programService.getPrograms(filter, ADMIN_USER, 0, 10).size());
        filter.setType(EntityFilterType.MANUAL);
        ProgramServiceTest.assertEquals((int)2, (int)this.programService.getPrograms(filter, ADMIN_USER, 0, 10).size());
        this.newDomain(EntityType.MANUAL, "domain6", false, new HashSet<Long>());
        ProgramServiceTest.assertEquals((int)2, (int)this.programService.getPrograms(filter, ADMIN_USER, 0, 10).size());
        filter.setStatus(EntityStatusType.ALL);
        filter.setType(EntityFilterType.ALL);
        ProgramServiceTest.assertEquals((int)6, (int)this.programService.getPrograms(filter, ADMIN_USER, 0, 10).size());
        filter.setStatus(EntityStatusType.DISABLED);
        ProgramServiceTest.assertEquals((int)2, (int)this.programService.getPrograms(filter, ADMIN_USER, 0, 10).size());
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramServiceTest.assertEquals((int)1, (int)this.programService.getPrograms(filter, ADMIN_USER, 0, 10).size());
        filter.setType(EntityFilterType.MANUAL);
        ProgramServiceTest.assertEquals((int)1, (int)this.programService.getPrograms(filter, ADMIN_USER, 0, 10).size());
    }

    @Test
    public void testGetProgramsAsInternalUser() throws IllegalAccessException {
        ProgramFilter filter = new ProgramFilter();
        filter.setType(EntityFilterType.ALL);
        filter.setStatus(EntityStatusType.ENABLED);
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.getPrograms(filter, INTERNAL_USER, 0, 10).size());
        this.newDomain(EntityType.MANUAL, "domain1", true, new HashSet<Long>());
        this.newDomain(EntityType.MANUAL, "domain2", true, new HashSet<Long>());
        this.newDomain(EntityType.AUTOMATIC, "domain3", true, new HashSet<Long>());
        this.newDomain(EntityType.AUTOMATIC, "domain4", true, new HashSet<Long>());
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.getPrograms(filter, INTERNAL_USER, 0, 10).size());
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.getPrograms(filter, INTERNAL_USER, 0, 10).size());
        this.newDomain(EntityType.AUTOMATIC, "domain5", false, new HashSet<Long>());
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.getPrograms(filter, INTERNAL_USER, 0, 10).size());
        filter.setType(EntityFilterType.MANUAL);
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.getPrograms(filter, INTERNAL_USER, 0, 10).size());
        this.newDomain(EntityType.MANUAL, "domain6", false, new HashSet<Long>());
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.getPrograms(filter, INTERNAL_USER, 0, 10).size());
        filter.setStatus(EntityStatusType.ALL);
        filter.setType(EntityFilterType.ALL);
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.getPrograms(filter, INTERNAL_USER, 0, 10).size());
        filter.setStatus(EntityStatusType.DISABLED);
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.getPrograms(filter, INTERNAL_USER, 0, 10).size());
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.getPrograms(filter, INTERNAL_USER, 0, 10).size());
        filter.setType(EntityFilterType.MANUAL);
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.getPrograms(filter, INTERNAL_USER, 0, 10).size());
    }

    @Test
    public void testGetOpenProgramsAsInternalUser() throws IllegalAccessException {
        ProgramFilter filter = new ProgramFilter();
        filter.setType(EntityFilterType.ALL);
        filter.setStatus(EntityStatusType.ENABLED);
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.getPrograms(filter, INTERNAL_USER, 0, 10).size());
        this.newDomain(EntityType.MANUAL, "domain1", true, null, null);
        this.newDomain(EntityType.MANUAL, "domain2", true, new HashSet<Long>(), null);
        this.newDomain(EntityType.AUTOMATIC, "domain3", true, new HashSet<Long>(), null);
        this.newDomain(EntityType.AUTOMATIC, "domain4", true, new HashSet<Long>(), null);
        ProgramServiceTest.assertEquals((int)4, (int)this.programService.getPrograms(filter, INTERNAL_USER, 0, 10).size());
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramServiceTest.assertEquals((int)2, (int)this.programService.getPrograms(filter, INTERNAL_USER, 0, 10).size());
        this.newDomain(EntityType.AUTOMATIC, "domain5", false, new HashSet<Long>(), null);
        ProgramServiceTest.assertEquals((int)2, (int)this.programService.getPrograms(filter, INTERNAL_USER, 0, 10).size());
        filter.setType(EntityFilterType.MANUAL);
        ProgramServiceTest.assertEquals((int)2, (int)this.programService.getPrograms(filter, INTERNAL_USER, 0, 10).size());
        this.newDomain(EntityType.MANUAL, "domain6", false, new HashSet<Long>(), null);
        ProgramServiceTest.assertEquals((int)2, (int)this.programService.getPrograms(filter, INTERNAL_USER, 0, 10).size());
        filter.setStatus(EntityStatusType.ALL);
        filter.setType(EntityFilterType.ALL);
        ProgramServiceTest.assertEquals((int)6, (int)this.programService.getPrograms(filter, INTERNAL_USER, 0, 10).size());
        filter.setStatus(EntityStatusType.DISABLED);
        ProgramServiceTest.assertEquals((int)2, (int)this.programService.getPrograms(filter, INTERNAL_USER, 0, 10).size());
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramServiceTest.assertEquals((int)1, (int)this.programService.getPrograms(filter, INTERNAL_USER, 0, 10).size());
        filter.setType(EntityFilterType.MANUAL);
        ProgramServiceTest.assertEquals((int)1, (int)this.programService.getPrograms(filter, INTERNAL_USER, 0, 10).size());
    }

    @Test
    public void testGetProgramsAsSpaceMemberUser() throws IllegalAccessException {
        ProgramFilter filter = new ProgramFilter();
        filter.setType(EntityFilterType.ALL);
        filter.setStatus(EntityStatusType.ENABLED);
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.getPrograms(filter, SPACE_MEMBER_USER, 0, 10).size());
        this.newDomain(EntityType.MANUAL, "domain1", true, new HashSet<Long>());
        this.newDomain(EntityType.MANUAL, "domain2", true, new HashSet<Long>());
        this.newDomain(EntityType.AUTOMATIC, "domain3", true, new HashSet<Long>());
        this.newDomain(EntityType.AUTOMATIC, "domain4", true, new HashSet<Long>());
        ProgramServiceTest.assertEquals((int)4, (int)this.programService.getPrograms(filter, SPACE_MEMBER_USER, 0, 10).size());
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramServiceTest.assertEquals((int)2, (int)this.programService.getPrograms(filter, SPACE_MEMBER_USER, 0, 10).size());
        this.newDomain(EntityType.AUTOMATIC, "domain5", false, new HashSet<Long>());
        ProgramServiceTest.assertEquals((int)2, (int)this.programService.getPrograms(filter, SPACE_MEMBER_USER, 0, 10).size());
        filter.setType(EntityFilterType.MANUAL);
        ProgramServiceTest.assertEquals((int)2, (int)this.programService.getPrograms(filter, SPACE_MEMBER_USER, 0, 10).size());
        this.newDomain(EntityType.MANUAL, "domain6", false, new HashSet<Long>());
        ProgramServiceTest.assertEquals((int)2, (int)this.programService.getPrograms(filter, SPACE_MEMBER_USER, 0, 10).size());
        filter.setStatus(EntityStatusType.ALL);
        filter.setType(EntityFilterType.ALL);
        ProgramServiceTest.assertEquals((int)6, (int)this.programService.getPrograms(filter, SPACE_MEMBER_USER, 0, 10).size());
        filter.setStatus(EntityStatusType.DISABLED);
        ProgramServiceTest.assertEquals((int)2, (int)this.programService.getPrograms(filter, SPACE_MEMBER_USER, 0, 10).size());
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramServiceTest.assertEquals((int)1, (int)this.programService.getPrograms(filter, SPACE_MEMBER_USER, 0, 10).size());
        filter.setType(EntityFilterType.MANUAL);
        ProgramServiceTest.assertEquals((int)1, (int)this.programService.getPrograms(filter, SPACE_MEMBER_USER, 0, 10).size());
    }

    @Test
    public void testGetProgramsByFilter() throws IllegalAccessException {
        ProgramFilter filter = new ProgramFilter();
        filter.setType(EntityFilterType.ALL);
        filter.setStatus(EntityStatusType.ENABLED);
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.getPrograms(filter, ADMIN_USER, 0, 10).size());
        this.newDomain(EntityType.AUTOMATIC, "domain5", true, new HashSet<Long>());
        filter.setOwnerId(1L);
        ProgramServiceTest.assertEquals((int)1, (int)this.programService.getPrograms(filter, ADMIN_USER, 0, 10).size());
    }

    @Test
    public void testGetProgramsByOwner() throws IllegalAccessException {
        ProgramFilter filter = new ProgramFilter();
        filter.setType(EntityFilterType.ALL);
        filter.setStatus(EntityStatusType.ENABLED);
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.getPrograms(filter, SPACE_MEMBER_USER, 0, 10).size());
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.countPrograms(filter, SPACE_MEMBER_USER));
        ProgramEntity programEntity = this.newDomain(EntityType.AUTOMATIC, "domain10", true, Collections.emptySet());
        filter.setOwnerId(10L);
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.getPrograms(filter, SPACE_MEMBER_USER, 0, 10).size());
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.countPrograms(filter, SPACE_MEMBER_USER));
        programEntity.setOwners(Collections.singleton(10L));
        this.programDAO.update((Object)programEntity);
        ProgramServiceTest.assertEquals((int)1, (int)this.programService.getPrograms(filter, SPACE_MEMBER_USER, 0, 10).size());
        ProgramServiceTest.assertEquals((int)1, (int)this.programService.countPrograms(filter, SPACE_MEMBER_USER));
    }

    @Test
    public void testGetProgramsByAnonym() throws IllegalAccessException, ObjectNotFoundException {
        ProgramFilter filter = new ProgramFilter();
        filter.setType(EntityFilterType.ALL);
        filter.setStatus(EntityStatusType.ENABLED);
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.getPrograms(filter, null, 0, 10).size());
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.countPrograms(filter, null));
        ProgramEntity programEntity = this.newDomain(EntityType.AUTOMATIC, "domain10", true, Collections.emptySet());
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.getPrograms(filter, null, 0, 10).size());
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.countPrograms(filter, null));
        ProgramDTO program = this.programService.getProgramById(programEntity.getId().longValue());
        program.setSpaceId(Long.parseLong("200"));
        this.programService.updateProgram(program);
        ProgramServiceTest.assertEquals((int)1, (int)this.programService.getPrograms(filter, null, 0, 10).size());
        ProgramServiceTest.assertEquals((int)1, (int)this.programService.countPrograms(filter, null));
    }

    @Test
    public void testGetProgramsBySpaceExcludeOpen() throws IllegalAccessException {
        ProgramFilter filter = new ProgramFilter();
        filter.setType(EntityFilterType.ALL);
        filter.setStatus(EntityStatusType.ENABLED);
        filter.setAllSpaces(true);
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.getProgramIds(filter, 0, 10).size());
        ProgramEntity program1 = this.newDomain(EntityType.MANUAL, "program1", true, new HashSet<Long>());
        program1.setAudienceId(null);
        this.programDAO.update((Object)program1);
        ProgramEntity program2 = this.newDomain(EntityType.MANUAL, "program2", true, new HashSet<Long>());
        program2.setAudienceId(Long.valueOf(2L));
        this.programDAO.update((Object)program2);
        ProgramEntity program3 = this.newDomain(EntityType.AUTOMATIC, "program3", true, new HashSet<Long>());
        program3.setAudienceId(Long.valueOf(3L));
        this.programDAO.update((Object)program3);
        ProgramEntity program4 = this.newDomain(EntityType.AUTOMATIC, "program4", true, new HashSet<Long>());
        ProgramServiceTest.assertEquals((long)1L, (long)program4.getAudienceId());
        ProgramServiceTest.assertEquals((int)4, (int)this.programService.getProgramIds(filter, 0, 10).size());
        filter.setSpacesIds(Collections.singletonList(1L));
        ProgramServiceTest.assertEquals(Arrays.asList(program4.getId(), program1.getId()), (Object)this.programService.getProgramIds(filter, 0, 10));
        filter.setExcludeOpen(true);
        ProgramServiceTest.assertEquals(Arrays.asList(program4.getId()), (Object)this.programService.getProgramIds(filter, 0, 10));
    }

    @Test
    public void testCountProgramsByOwner() throws IllegalAccessException {
        ProgramFilter filter = new ProgramFilter();
        filter.setType(EntityFilterType.ALL);
        filter.setStatus(EntityStatusType.ENABLED);
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.getPrograms(filter, SPACE_MEMBER_USER, 0, 10).size());
        ProgramEntity domainEntity = this.newDomain(EntityType.AUTOMATIC, "domain10", true, Collections.emptySet());
        filter.setOwnerId(10L);
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.countPrograms(filter, SPACE_MEMBER_USER));
        domainEntity.setOwners(Collections.singleton(10L));
        this.programDAO.update((Object)domainEntity);
        ProgramServiceTest.assertEquals((int)1, (int)this.programService.countPrograms(filter, SPACE_MEMBER_USER));
    }

    @Test
    public void testCountPrograms() throws IllegalAccessException {
        ProgramFilter filter = new ProgramFilter();
        filter.setType(EntityFilterType.ALL);
        filter.setStatus(EntityStatusType.ENABLED);
        ProgramServiceTest.assertEquals((int)0, (int)this.programService.countPrograms(filter, ADMIN_USER));
        this.newDomain(EntityType.MANUAL, "domain1", true, new HashSet<Long>());
        this.newDomain(EntityType.MANUAL, "domain2", true, new HashSet<Long>());
        this.newDomain(EntityType.AUTOMATIC, "domain3", true, new HashSet<Long>());
        this.newDomain(EntityType.AUTOMATIC, "domain4", true, new HashSet<Long>());
        ProgramServiceTest.assertEquals((int)4, (int)this.programService.countPrograms(filter, ADMIN_USER));
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramServiceTest.assertEquals((int)2, (int)this.programService.countPrograms(filter, ADMIN_USER));
        this.newDomain(EntityType.AUTOMATIC, "domain5", false, new HashSet<Long>());
        ProgramServiceTest.assertEquals((int)2, (int)this.programService.countPrograms(filter, ADMIN_USER));
        filter.setType(EntityFilterType.MANUAL);
        ProgramServiceTest.assertEquals((int)2, (int)this.programService.countPrograms(filter, ADMIN_USER));
        this.newDomain(EntityType.MANUAL, "domain6", false, new HashSet<Long>());
        ProgramServiceTest.assertEquals((int)2, (int)this.programService.countPrograms(filter, ADMIN_USER));
        filter.setStatus(EntityStatusType.ALL);
        filter.setType(EntityFilterType.ALL);
        ProgramServiceTest.assertEquals((int)6, (int)this.programService.countPrograms(filter, ADMIN_USER));
        filter.setStatus(EntityStatusType.DISABLED);
        ProgramServiceTest.assertEquals((int)2, (int)this.programService.countPrograms(filter, ADMIN_USER));
        filter.setType(EntityFilterType.AUTOMATIC);
        ProgramServiceTest.assertEquals((int)1, (int)this.programService.countPrograms(filter, ADMIN_USER));
        filter.setType(EntityFilterType.MANUAL);
        ProgramServiceTest.assertEquals((int)1, (int)this.programService.countPrograms(filter, ADMIN_USER));
    }

    @Test
    public void testCreateProgram() throws IllegalAccessException {
        ProgramServiceTest.assertEquals((long)0L, (long)this.programDAO.count());
        ProgramDTO program = new ProgramDTO();
        program.setTitle("TeamWork");
        program.setDescription("Description");
        program.setDeleted(false);
        program.setEnabled(true);
        program.setBudget(20L);
        program.setColor("#FFEECCDD");
        Assert.assertThrows(IllegalArgumentException.class, () -> this.programService.createProgram(null, this.adminAclIdentity));
        ProgramDTO domainWithId = new ProgramDTO();
        domainWithId.setId(150L);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.programService.createProgram(domainWithId, this.adminAclIdentity));
        program = this.programService.createProgram(program, this.adminAclIdentity);
        ProgramServiceTest.assertNotNull((Object)program);
        ProgramServiceTest.assertEquals((String)EntityType.MANUAL.name(), (String)program.getType());
        ProgramServiceTest.assertNotNull((Object)this.programDAO.find((Serializable)Long.valueOf(program.getId())));
        ProgramDTO programToSave = new ProgramDTO();
        programToSave.setTitle("TeamWork");
        programToSave.setDescription("Description");
        programToSave.setDeleted(false);
        programToSave.setEnabled(true);
        programToSave.setBudget(20L);
        programToSave.setColor("#FFEECCdd");
        programToSave.setOwnerIds(Collections.emptySet());
        programToSave.setCoverFileId(1L);
        programToSave.setAvatarFileId(2L);
        programToSave.setType(EntityType.MANUAL.name());
        Assert.assertThrows(IllegalAccessException.class, () -> this.programService.createProgram(programToSave, this.spaceMemberAclIdentity));
        Assert.assertThrows(ProgramColorAlreadyExists.class, () -> this.programService.createProgram(programToSave, this.adminAclIdentity));
        programToSave.setColor("#FFEECCEE");
        ProgramDTO savedDomain = this.programService.createProgram(programToSave, this.adminAclIdentity);
        ProgramServiceTest.assertNotNull((Object)savedDomain);
        savedDomain = this.programService.getProgramById(savedDomain.getId());
        ProgramServiceTest.assertEquals((String)"TeamWork", (String)programToSave.getTitle());
        ProgramServiceTest.assertEquals((String)"Description", (String)programToSave.getDescription());
        ProgramServiceTest.assertEquals((String)this.adminAclIdentity.getUserId(), (String)programToSave.getCreatedBy());
        ProgramServiceTest.assertEquals((String)this.adminAclIdentity.getUserId(), (String)programToSave.getLastModifiedBy());
        ProgramServiceTest.assertFalse((boolean)programToSave.isDeleted());
        ProgramServiceTest.assertTrue((boolean)programToSave.isEnabled());
        ProgramServiceTest.assertEquals((long)20L, (long)programToSave.getBudget());
        ProgramServiceTest.assertEquals((long)1L, (long)programToSave.getCoverFileId());
        ProgramServiceTest.assertEquals((long)2L, (long)programToSave.getAvatarFileId());
        ProgramServiceTest.assertEquals((String)"#FFEECCEE", (String)programToSave.getColor());
        ProgramServiceTest.assertEquals((String)EntityType.MANUAL.name(), (String)savedDomain.getType());
        ProgramServiceTest.assertNotNull((Object)programToSave.getCreatedDate());
        ProgramServiceTest.assertNotNull((Object)programToSave.getLastModifiedDate());
        Assert.assertThrows(ProgramColorAlreadyExists.class, () -> this.programService.createProgram(programToSave, this.adminAclIdentity));
        programToSave.setColor("#FFEECCBB");
        program = this.programService.createProgram(programToSave);
        ProgramServiceTest.assertNotNull((Object)program);
        ProgramServiceTest.assertEquals((String)EntityType.AUTOMATIC.name(), (String)program.getType());
        ProgramServiceTest.assertEquals((String)"#FFEECCBB", (String)program.getColor());
    }

    @Test
    public void testUpdateProgram() throws Exception {
        ProgramDTO programWithColor = new ProgramDTO();
        programWithColor.setTitle("TeamWork");
        programWithColor.setDescription("Description");
        programWithColor.setDeleted(false);
        programWithColor.setEnabled(true);
        programWithColor.setBudget(20L);
        programWithColor.setColor("#FFEECCDD");
        programWithColor = this.programService.createProgram(programWithColor, this.adminAclIdentity);
        String newTitle = "title_2";
        String newDescription = "desc_2";
        long newBudget = 30L;
        ProgramDTO notExistDomain = new ProgramDTO();
        notExistDomain.setId(150L);
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.programService.updateProgram(notExistDomain, this.adminAclIdentity));
        ProgramDTO program = this.newProgram(EntityType.MANUAL, "domain1", true, Collections.singleton(1L));
        program.setDescription(newDescription);
        program.setTitle(newTitle);
        program.setBudget(newBudget);
        program.setEnabled(true);
        Assert.assertThrows(IllegalAccessException.class, () -> this.programService.updateProgram(program, this.spaceMemberAclIdentity));
        OrganizationService organizationService = (OrganizationService)ExoContainerContext.getService(OrganizationService.class);
        User user = organizationService.getUserHandler().createUserInstance(this.spaceMemberAclIdentity.getUserId());
        user.setFirstName("Regular");
        user.setLastName("User");
        user.setEmail("regularuser@localhost.com");
        organizationService.getUserHandler().createUser(user, true);
        String ownerId = this.identityManager.getOrCreateUserIdentity(user.getUserName()).getId();
        Set<Long> newOwners = Collections.singleton(Long.parseLong(ownerId));
        program.setOwnerIds(newOwners);
        program.setEnabled(false);
        ProgramDTO updatedDomain = this.programService.updateProgram(program, this.adminAclIdentity);
        ProgramServiceTest.assertFalse((boolean)updatedDomain.isEnabled());
        updatedDomain.setEnabled(true);
        updatedDomain.setColor("#FFEECCEE");
        this.programService.updateProgram(updatedDomain, this.adminAclIdentity);
        ProgramDTO storedDomain = this.programService.getProgramById(updatedDomain.getId());
        ProgramServiceTest.assertNotNull((Object)storedDomain);
        ProgramServiceTest.assertEquals((String)newDescription, (String)storedDomain.getDescription());
        ProgramServiceTest.assertEquals((String)newTitle, (String)storedDomain.getTitle());
        ProgramServiceTest.assertEquals((long)newBudget, (long)storedDomain.getBudget());
        ProgramServiceTest.assertEquals(newOwners, (Object)storedDomain.getOwnerIds());
        ProgramServiceTest.assertEquals((String)"#FFEECCEE", (String)storedDomain.getColor());
        ProgramServiceTest.assertTrue((boolean)storedDomain.isEnabled());
        updatedDomain = this.programService.updateProgram(updatedDomain, this.adminAclIdentity);
        ProgramServiceTest.assertEquals((String)"#FFEECCEE", (String)storedDomain.getColor());
        updatedDomain.setColor(programWithColor.getColor());
        ProgramDTO programToUpdate = updatedDomain.clone();
        Assert.assertThrows(ProgramColorAlreadyExists.class, () -> this.programService.updateProgram(programToUpdate, this.adminAclIdentity));
        this.programService.deleteProgramById(programWithColor.getId(), this.adminAclIdentity);
        updatedDomain = this.programService.updateProgram(programToUpdate, this.adminAclIdentity);
        ProgramServiceTest.assertEquals((String)programWithColor.getColor(), (String)updatedDomain.getColor());
        this.programService.deleteProgramById(storedDomain.getId(), this.adminAclIdentity);
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.programService.updateProgram(programToUpdate, this.spaceMemberAclIdentity));
    }

    @Test
    public void testCanUseProgramColor() throws Exception {
        ProgramDTO programWithColor = new ProgramDTO();
        programWithColor.setTitle("TeamWork");
        programWithColor.setDescription("Description");
        programWithColor.setDeleted(false);
        programWithColor.setEnabled(true);
        programWithColor.setBudget(20L);
        programWithColor.setColor("#FFEECCDD");
        programWithColor = this.programService.createProgram(programWithColor, this.adminAclIdentity);
        ProgramServiceTest.assertTrue((boolean)this.programService.canUseProgramColor(programWithColor.getId(), programWithColor.getColor()));
        ProgramServiceTest.assertFalse((boolean)this.programService.canUseProgramColor(0L, programWithColor.getColor()));
        ProgramServiceTest.assertTrue((boolean)this.programService.canUseProgramColor(0L, "#FFEECCCC"));
        ProgramServiceTest.assertTrue((boolean)this.programService.canUseProgramColor(0L, null));
    }

    @Test
    public void testDeleteProgram() throws Exception {
        ProgramDTO domain = this.newProgram(EntityType.MANUAL, "domain1", true, Collections.singleton(1L));
        ProgramServiceTest.assertFalse((boolean)domain.isDeleted());
        domain.setDeleted(true);
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.programService.deleteProgramById(20000L, this.adminAclIdentity));
        Assert.assertThrows(IllegalAccessException.class, () -> this.programService.deleteProgramById(domain.getId(), this.spaceMemberAclIdentity));
        this.programService.deleteProgramById(domain.getId(), this.adminAclIdentity);
        ProgramEntity domainEntity = (ProgramEntity)this.programDAO.find((Serializable)Long.valueOf(domain.getId()));
        ProgramServiceTest.assertTrue((boolean)domainEntity.isDeleted());
    }

    @Test
    public void testDisableProgramReturnsNoPoints() throws Exception {
        RuleDTO rule = this.newRuleDTO();
        ProgramDTO program = rule.getProgram();
        ProgramServiceTest.assertEquals((long)rule.getScore(), (long)program.getRulesTotalScore());
        program.setEnabled(false);
        program = this.programService.updateProgram(program, this.adminAclIdentity);
        ProgramServiceTest.assertEquals((long)0L, (long)program.getRulesTotalScore());
        program.setEnabled(true);
        program = this.programService.updateProgram(program, this.adminAclIdentity);
        ProgramServiceTest.assertEquals((long)rule.getScore(), (long)program.getRulesTotalScore());
        program = this.programService.getProgramById(program.getId(), this.adminAclIdentity.getUserId());
        ProgramServiceTest.assertEquals((long)rule.getScore(), (long)program.getRulesTotalScore());
    }

    @Test
    public void testGetProgramById() {
        ProgramServiceTest.assertEquals((int)this.programDAO.findAll().size(), (int)0);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.programService.getProgramById(-1L));
        ProgramDTO program = this.newProgram();
        ProgramServiceTest.assertNotNull((Object)program);
        ProgramDTO domain = this.programService.getProgramById(program.getId());
        ProgramServiceTest.assertNotNull((Object)domain);
        ProgramServiceTest.assertEquals((long)program.getId(), (long)domain.getId());
    }

    @Test
    public void testGetProgramByIdAndUser() throws IllegalAccessException, ObjectNotFoundException {
        ProgramServiceTest.assertEquals((int)this.programDAO.findAll().size(), (int)0);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.programService.getProgramById(-1L, ADMIN_USER));
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.programService.getProgramById(5000L, ADMIN_USER));
        ProgramDTO program = this.newProgram();
        ProgramServiceTest.assertNotNull((Object)program);
        long programId = program.getId();
        ProgramDTO foundProgram = this.programService.getProgramById(programId, ADMIN_USER);
        ProgramServiceTest.assertNotNull((Object)foundProgram);
        ProgramServiceTest.assertEquals((long)programId, (long)foundProgram.getId());
        ProgramServiceTest.assertTrue((boolean)program.isEnabled());
        ProgramServiceTest.assertNotNull((Object)this.programService.getProgramById(programId, SPACE_MEMBER_USER));
        Assert.assertThrows(IllegalAccessException.class, () -> this.programService.getProgramById(programId, "demo"));
        program.setEnabled(false);
        this.programService.updateProgram(program, this.adminAclIdentity);
        ProgramServiceTest.assertNotNull((Object)this.programService.getProgramById(programId, ADMIN_USER));
        ProgramServiceTest.assertNotNull((Object)this.programService.getProgramById(programId, SPACE_MEMBER_USER));
        Assert.assertThrows(IllegalAccessException.class, () -> this.programService.getProgramById(programId, "demo"));
        this.programService.deleteProgramById(programId, this.adminAclIdentity);
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.programService.getProgramById(programId, ADMIN_USER));
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.programService.getProgramById(programId, SPACE_MEMBER_USER));
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.programService.getProgramById(programId, "demo"));
    }

    @Test
    public void testGetProgramCoverAsStream() throws Exception {
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.programService.getProgramCoverStream(0L));
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.programService.getProgramCoverStream(150L));
        String uplaodId = "uplaodId" + new Random().nextInt();
        File tempFile = File.createTempFile("image", "temp");
        ProgramDTO domain = this.newProgram();
        long domainId = domain.getId();
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.programService.getProgramCoverStream(domainId));
        MockUploadService uploadService = (MockUploadService)ExoContainerContext.getService(UploadService.class);
        uploadService.createUploadResource(uplaodId, tempFile.getPath(), "cover.png", "image/png");
        domain.setCoverUploadId(uplaodId);
        domain = this.programService.updateProgram(domain, this.adminAclIdentity);
        ProgramServiceTest.assertNotNull((Object)this.programService.getProgramCoverStream(domain.getId()));
    }

    @Test
    public void testGetProgramAvatarAsStream() throws Exception {
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.programService.getProgramAvatarStream(0L));
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.programService.getProgramAvatarStream(150L));
        String uplaodId = "uplaodId" + new Random().nextInt();
        File tempFile = File.createTempFile("image", "temp");
        ProgramDTO domain = this.newProgram();
        long domainId = domain.getId();
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.programService.getProgramAvatarStream(domainId));
        MockUploadService uploadService = (MockUploadService)ExoContainerContext.getService(UploadService.class);
        uploadService.createUploadResource(uplaodId, tempFile.getPath(), "avatar.png", "image/png");
        domain.setAvatarUploadId(uplaodId);
        domain = this.programService.updateProgram(domain, this.adminAclIdentity);
        ProgramServiceTest.assertNotNull((Object)this.programService.getProgramAvatarStream(domain.getId()));
    }

    @Test
    public void testDeleteProgramCover() throws Exception {
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.programService.getProgramCoverStream(0L));
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.programService.getProgramCoverStream(150L));
        String uplaodId = "uplaodId" + new Random().nextInt();
        File tempFile = File.createTempFile("image", "temp");
        ProgramDTO domain = this.newProgram();
        long domainId = domain.getId();
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.programService.getProgramCoverStream(domainId));
        MockUploadService uploadService = (MockUploadService)ExoContainerContext.getService(UploadService.class);
        uploadService.createUploadResource(uplaodId, tempFile.getPath(), "cover.png", "image/png");
        domain.setCoverUploadId(uplaodId);
        domain = this.programService.updateProgram(domain, this.adminAclIdentity);
        ProgramServiceTest.assertNotNull((Object)this.programService.getProgramCoverStream(domain.getId()));
        this.programService.deleteProgramCoverById(domainId, this.adminAclIdentity);
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.programService.getProgramCoverStream(domainId));
    }

    @Test
    public void testDeleteProgramAvatar() throws Exception {
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.programService.getProgramAvatarStream(0L));
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.programService.getProgramAvatarStream(150L));
        String uplaodId = "uplaodId" + new Random().nextInt();
        File tempFile = File.createTempFile("image", "temp");
        ProgramDTO domain = this.newProgram();
        long domainId = domain.getId();
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.programService.getProgramAvatarStream(domainId));
        MockUploadService uploadService = (MockUploadService)ExoContainerContext.getService(UploadService.class);
        uploadService.createUploadResource(uplaodId, tempFile.getPath(), "avatar.png", "image/png");
        domain.setAvatarUploadId(uplaodId);
        domain = this.programService.updateProgram(domain, this.adminAclIdentity);
        ProgramServiceTest.assertNotNull((Object)this.programService.getProgramAvatarStream(domain.getId()));
        this.programService.deleteProgramAvatarById(domainId, this.adminAclIdentity);
        Assert.assertThrows(ObjectNotFoundException.class, () -> this.programService.getProgramAvatarStream(domainId));
    }

    @Test
    public void testCanAddProgram() {
        ProgramServiceTest.assertFalse((boolean)this.programService.canAddProgram(null));
        ProgramServiceTest.assertFalse((boolean)this.programService.canAddProgram(this.spaceMemberAclIdentity));
        ProgramServiceTest.assertTrue((boolean)this.programService.canAddProgram(this.adminAclIdentity));
    }

    @Test
    public void testCanUpdateProgram() throws IllegalAccessException, ObjectNotFoundException {
        ProgramDTO domain = this.newProgram();
        ProgramServiceTest.assertFalse((boolean)this.programService.isProgramOwner(domain.getId(), this.spaceMemberAclIdentity.getUserId()));
        ProgramServiceTest.assertTrue((boolean)this.programService.isProgramOwner(domain.getId(), this.adminAclIdentity.getUserId()));
        ProgramServiceTest.assertFalse((boolean)this.programService.isProgramOwner(0L, this.spaceMemberAclIdentity.getUserId()));
        String identityId = this.identityManager.getOrCreateUserIdentity(this.spaceMemberAclIdentity.getUserId()).getId();
        domain.setOwnerIds(Collections.singleton(Long.parseLong(identityId)));
        this.programService.updateProgram(domain, this.adminAclIdentity);
        ProgramServiceTest.assertTrue((boolean)this.programService.isProgramOwner(domain.getId(), this.spaceMemberAclIdentity.getUserId()));
    }
}

