/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service;

import io.meeds.gamification.entity.BadgeEntity;
import io.meeds.gamification.entity.ProgramEntity;
import io.meeds.gamification.model.BadgeDTO;
import io.meeds.gamification.storage.ProgramStorage;
import io.meeds.gamification.storage.mapper.BadgeMapper;
import io.meeds.gamification.test.AbstractServiceTest;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.Assert;
import org.junit.Test;

public class BadgeServiceTest
extends AbstractServiceTest {
    @Test
    public void testFindBadgeByTitle() {
        ProgramEntity domainEntity = this.newDomain();
        BadgeServiceTest.assertNull((Object)this.badgeService.findBadgeByTitle("TeamLeader"));
        BadgeEntity badge = this.newBadge(domainEntity.getId());
        BadgeDTO badge_ = this.badgeService.findBadgeByTitle("TeamLeader");
        BadgeServiceTest.assertNotNull((Object)badge_);
        BadgeServiceTest.assertEquals((String)badge.getTitle(), (String)badge_.getTitle());
    }

    @Test
    public void testGetAllBadges() {
        ProgramEntity domainEntity1 = this.newDomain();
        ProgramEntity domainEntity2 = this.newDomain();
        ProgramEntity domainEntity3 = this.newDomain();
        ProgramEntity domainEntity4 = this.newDomain();
        ProgramEntity domainEntity5 = this.newDomain();
        BadgeServiceTest.assertEquals((int)this.badgeService.getAllBadges().size(), (int)0);
        this.newBadge("badge1", domainEntity1.getId());
        this.newBadge("badge2", domainEntity2.getId());
        this.newBadge("badge3", domainEntity3.getId());
        this.newBadge("badge4", domainEntity4.getId());
        this.newBadge("badge5", domainEntity5.getId());
        BadgeServiceTest.assertEquals((int)this.badgeService.getAllBadges().size(), (int)5);
    }

    @Test
    public void testFindBadge() {
        ProgramEntity domainEntity = this.newDomain();
        BadgeEntity badgeEntity = this.newBadge("badge1", domainEntity.getId());
        BadgeServiceTest.assertNotNull((Object)this.badgeService.findBadgeById(badgeEntity.getId()));
        BadgeServiceTest.assertNotNull((Object)this.badgeService.findBadgeByTitleAndProgramId("badge1", domainEntity.getId().longValue()));
    }

    @Test
    public void testAddBadge() throws ObjectAlreadyExistsException {
        BadgeServiceTest.assertNull((Object)this.badgeService.findBadgeByTitle("TeamLeader"));
        BadgeDTO badge = new BadgeDTO();
        badge.setTitle("TeamLeader");
        badge.setDescription("Description");
        badge.setNeededScore(Integer.parseInt("245590"));
        badge.setProgram(this.newProgram("TeamWork"));
        badge.setIconFileId(10245L);
        badge.setEnabled(true);
        badge.setDeleted(false);
        badge.setCreatedBy("1");
        badge.setLastModifiedBy("1");
        badge = this.badgeService.addBadge(badge);
        BadgeServiceTest.assertNotNull((Object)badge);
        BadgeServiceTest.assertNotNull((Object)this.badgeService.findBadgeByTitle("TeamLeader"));
        BadgeDTO finalBadge = badge;
        Assert.assertThrows(ObjectAlreadyExistsException.class, () -> this.badgeService.addBadge(finalBadge));
        badge.setDeleted(true);
        this.badgeService.updateBadge(badge);
        badge = this.badgeService.addBadge(badge);
        BadgeServiceTest.assertNotNull((Object)badge);
        BadgeServiceTest.assertNotNull((Object)this.badgeService.findBadgeByTitle("TeamLeader"));
    }

    @Test
    public void testUpdateBadge() throws ObjectAlreadyExistsException {
        ProgramEntity domainEntity = this.newDomain();
        BadgeEntity badge = this.newBadge(domainEntity.getId());
        badge.setDescription("Desc_2");
        this.badgeService.updateBadge(BadgeMapper.fromEntity((ProgramStorage)this.programStorage, (BadgeEntity)badge));
        BadgeDTO badge_ = this.badgeService.findBadgeByTitle("TeamLeader");
        BadgeServiceTest.assertNotNull((Object)badge_);
        BadgeServiceTest.assertEquals((String)badge_.getDescription(), (String)"Desc_2");
    }

    @Test
    public void testDeleteBadge() throws ObjectNotFoundException {
        BadgeServiceTest.assertNull((Object)this.badgeService.findBadgeByTitle("TeamLeader"));
        BadgeEntity badge = this.newBadge(1L);
        BadgeDTO badge_ = this.badgeService.findBadgeByTitle("TeamLeader");
        BadgeServiceTest.assertNotNull((Object)badge_);
        this.badgeService.deleteBadge(badge.getId());
        badge_ = this.badgeService.findBadgeByTitle("TeamLeader");
        BadgeServiceTest.assertEquals((boolean)badge_.isDeleted(), (boolean)true);
    }

    @Test
    public void testFindBadgesByDomain() {
        ProgramEntity domainEntity1 = this.newDomain();
        ProgramEntity domainEntity2 = this.newDomain();
        BadgeServiceTest.assertEquals((int)this.badgeStorage.findAll().size(), (int)0);
        BadgeServiceTest.assertEquals((int)this.badgeService.findBadgesByProgramId(1L).size(), (int)0);
        BadgeServiceTest.assertEquals((int)this.badgeService.findBadgesByProgramId(2L).size(), (int)0);
        this.newBadge("badge1", domainEntity1.getId());
        this.newBadge("badge2", domainEntity1.getId());
        this.newBadge("badge3", domainEntity1.getId());
        this.newBadge("badge4", domainEntity2.getId());
        this.newBadge("badge5", domainEntity2.getId());
        BadgeServiceTest.assertEquals((int)this.badgeService.findBadgesByProgramId(domainEntity1.getId().longValue()).size(), (int)3);
        BadgeServiceTest.assertEquals((int)this.badgeService.findBadgesByProgramId(domainEntity2.getId().longValue()).size(), (int)2);
    }

    @Test
    public void testFindEnabledBadgesByDomain() {
        ProgramEntity domainEntity1 = this.newDomain();
        ProgramEntity domainEntity2 = this.newDomain();
        BadgeServiceTest.assertEquals((int)this.badgeStorage.findAll().size(), (int)0);
        BadgeServiceTest.assertEquals((int)this.badgeService.findEnabledBadgesByProgramId(domainEntity1.getId().longValue()).size(), (int)0);
        BadgeServiceTest.assertEquals((int)this.badgeService.findEnabledBadgesByProgramId(domainEntity2.getId().longValue()).size(), (int)0);
        this.newBadge("badge1", domainEntity1.getId());
        this.newBadge("badge2", domainEntity1.getId());
        this.newBadge("badge3", domainEntity1.getId());
        this.newBadge("badge4", domainEntity2.getId());
        this.newBadge("badge5", domainEntity2.getId());
        BadgeServiceTest.assertEquals((int)this.badgeService.findEnabledBadgesByProgramId(domainEntity1.getId().longValue()).size(), (int)3);
        BadgeServiceTest.assertEquals((int)this.badgeService.findEnabledBadgesByProgramId(domainEntity2.getId().longValue()).size(), (int)2);
        BadgeEntity badge_ = this.badgeStorage.findBadgeByTitle("badge1");
        badge_.setEnabled(false);
        this.badgeStorage.update((Object)badge_);
        BadgeServiceTest.assertEquals((int)this.badgeService.findEnabledBadgesByProgramId(domainEntity1.getId().longValue()).size(), (int)2);
    }
}

