/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.listener;

import io.meeds.gamification.listener.GamificationProfileListener;
import io.meeds.gamification.model.Announcement;
import java.util.Map;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.profile.ProfileLifeCycleEvent;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class GamificationProfileListenerTest {
    private static final String USERNAME = "test";
    private static final String OTHER_USERNAME = "test2";
    @Mock
    private ListenerService listenerService;
    @Mock
    private Identity identity;
    @Mock
    private Profile profile;

    @Before
    public void setup() {
        Mockito.when((Object)this.identity.getId()).thenReturn((Object)"1");
        Mockito.when((Object)this.identity.getRemoteId()).thenReturn((Object)USERNAME);
        Mockito.when((Object)this.profile.getIdentity()).thenReturn((Object)this.identity);
    }

    @Test
    public void testUpdateContactSectionUpdated() throws Exception {
        GamificationProfileListener gamificationProfileListener = new GamificationProfileListener(this.listenerService);
        Announcement announcement = new Announcement();
        announcement.setActivityId(Long.valueOf(1L));
        ProfileLifeCycleEvent event = new ProfileLifeCycleEvent(ProfileLifeCycleEvent.Type.CONTACT_UPDATED, USERNAME, this.profile, OTHER_USERNAME);
        gamificationProfileListener.contactSectionUpdated(event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.listenerService});
        event = new ProfileLifeCycleEvent(ProfileLifeCycleEvent.Type.CONTACT_UPDATED, USERNAME, this.profile, USERNAME);
        gamificationProfileListener.contactSectionUpdated(event);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("addUserProfileContactInformation") && ((String)source.get("senderId")).equals(String.valueOf(this.identity.getId())) && ((String)source.get("receiverId")).equals(String.valueOf(this.identity.getId())) && ((String)source.get("objectType")).equals("identity") && ((String)source.get("objectId")).equals(this.identity.getId()))), ArgumentMatchers.eq(null));
    }

    @Test
    public void testUpdateUserAvatar() throws Exception {
        GamificationProfileListener gamificationProfileListener = new GamificationProfileListener(this.listenerService);
        ProfileLifeCycleEvent event = new ProfileLifeCycleEvent(ProfileLifeCycleEvent.Type.CONTACT_UPDATED, USERNAME, this.profile, OTHER_USERNAME);
        gamificationProfileListener.avatarUpdated(event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.listenerService});
        event = new ProfileLifeCycleEvent(ProfileLifeCycleEvent.Type.CONTACT_UPDATED, USERNAME, this.profile, USERNAME);
        gamificationProfileListener.avatarUpdated(event);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("addUserProfileAvatar") && ((String)source.get("senderId")).equals(String.valueOf(this.identity.getId())) && ((String)source.get("receiverId")).equals(String.valueOf(this.identity.getId())) && ((String)source.get("objectType")).equals("identity") && ((String)source.get("objectId")).equals(this.identity.getId()))), ArgumentMatchers.eq(null));
    }

    @Test
    public void testUpdateUserBanner() throws Exception {
        GamificationProfileListener gamificationProfileListener = new GamificationProfileListener(this.listenerService);
        ProfileLifeCycleEvent event = new ProfileLifeCycleEvent(ProfileLifeCycleEvent.Type.CONTACT_UPDATED, USERNAME, this.profile, OTHER_USERNAME);
        gamificationProfileListener.bannerUpdated(event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.listenerService});
        event = new ProfileLifeCycleEvent(ProfileLifeCycleEvent.Type.CONTACT_UPDATED, USERNAME, this.profile, USERNAME);
        gamificationProfileListener.bannerUpdated(event);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("addUserProfileBanner") && ((String)source.get("senderId")).equals(String.valueOf(this.identity.getId())) && ((String)source.get("receiverId")).equals(String.valueOf(this.identity.getId())) && ((String)source.get("objectType")).equals("identity") && ((String)source.get("objectId")).equals(this.identity.getId()))), ArgumentMatchers.eq(null));
    }

    @Test
    public void testUpdateWorkExperience() throws Exception {
        GamificationProfileListener gamificationProfileListener = new GamificationProfileListener(this.listenerService);
        ProfileLifeCycleEvent event = new ProfileLifeCycleEvent(ProfileLifeCycleEvent.Type.CONTACT_UPDATED, USERNAME, this.profile, OTHER_USERNAME);
        gamificationProfileListener.experienceSectionUpdated(event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.listenerService});
        event = new ProfileLifeCycleEvent(ProfileLifeCycleEvent.Type.CONTACT_UPDATED, USERNAME, this.profile, USERNAME);
        gamificationProfileListener.experienceSectionUpdated(event);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("addUserProfileWorkExperience") && ((String)source.get("senderId")).equals(String.valueOf(this.identity.getId())) && ((String)source.get("receiverId")).equals(String.valueOf(this.identity.getId())) && ((String)source.get("objectType")).equals("identity") && ((String)source.get("objectId")).equals(this.identity.getId()))), ArgumentMatchers.eq(null));
    }
}

