/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.notification.plugin;

import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.constant.RecurrenceType;
import io.meeds.gamification.model.Announcement;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.RulePublication;
import io.meeds.gamification.test.AbstractPluginTest;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;

public class ContributionStatusUpdatedNotificationPluginTest
extends AbstractPluginTest {
    @Override
    public AbstractTemplateBuilder getTemplateBuilder() {
        return null;
    }

    @Override
    public BaseNotificationPlugin getPlugin() {
        return this.pluginService.getPlugin(PluginKey.key((String)"GamificationContributionAcceptedNotification"));
    }

    public void testSimpleCase() throws Exception {
        this.notificationService.clearAll();
        ProgramDTO program = new ProgramDTO();
        program.setTitle("TeamWork");
        program.setDescription("TeamWork");
        program.setCreatedBy("1");
        program.setLastModifiedBy("1");
        program.setDeleted(false);
        program.setEnabled(true);
        program.setSpaceId(1L);
        program = this.programService.createProgram(program);
        RulePublication rule = new RulePublication();
        rule.setScore(Integer.parseInt("50"));
        rule.setTitle("createNewTask");
        rule.setDescription("Description");
        rule.setEnabled(true);
        rule.setDeleted(false);
        rule.setProgram(program);
        rule.setType(EntityType.MANUAL);
        rule.setRecurrence(RecurrenceType.NONE);
        rule.setPublish(true);
        String message = "Test publication Message";
        rule.setMessage(message);
        RuleDTO createdRule = this.ruleService.createRule((RuleDTO)rule, "root1");
        ContributionStatusUpdatedNotificationPluginTest.assertTrue((createdRule.getActivityId() > 0L ? 1 : 0) != 0);
        Announcement announcement = new Announcement(0L, createdRule.getId(), createdRule.getTitle(), Long.valueOf(5L), "to accept", Long.valueOf(5L), null, null);
        announcement = this.announcementService.createAnnouncement(announcement, null, "root5");
        this.realizationService.updateRealizationStatus(announcement.getId(), RealizationStatus.ACCEPTED);
        List<NotificationInfo> list = this.assertMadeWebNotifications("root5", 1);
        NotificationInfo contributionAcceptedNotification = list.get(0);
        ContributionStatusUpdatedNotificationPluginTest.assertEquals((String)"GamificationContributionAcceptedNotification", (String)contributionAcceptedNotification.getKey().getId());
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(contributionAcceptedNotification.setTo("root5"));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertBody(info, rule.getTitle());
        ContributionStatusUpdatedNotificationPluginTest.assertEquals((String)"root5", (String)contributionAcceptedNotification.getTo());
        announcement = new Announcement(0L, createdRule.getId(), createdRule.getTitle(), Long.valueOf(5L), "to reject", Long.valueOf(5L), null, null);
        announcement = this.announcementService.createAnnouncement(announcement, null, "root5");
        this.realizationService.updateRealizationStatus(announcement.getId(), RealizationStatus.REJECTED);
        list = this.assertMadeWebNotifications("root5", 2);
        NotificationInfo contributionRejectedNotification = list.get(1);
        ContributionStatusUpdatedNotificationPluginTest.assertEquals((String)"GamificationContributionRejectedNotification", (String)contributionRejectedNotification.getKey().getId());
        ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(contributionRejectedNotification.setTo("root5"));
        info = this.buildMessageInfo(ctx);
        this.assertBody(info, rule.getTitle());
        ContributionStatusUpdatedNotificationPluginTest.assertEquals((String)"root5", (String)contributionRejectedNotification.getTo());
    }
}

