/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.rest;

import io.meeds.gamification.entity.BadgeEntity;
import io.meeds.gamification.entity.ProgramEntity;
import io.meeds.gamification.model.RealizationDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.rest.UserReputationEndpoint;
import io.meeds.gamification.test.AbstractServiceTest;
import java.util.Map;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.security.Identity;
import org.json.JSONArray;
import org.junit.Before;
import org.junit.Test;

public class TestUserReputationEndpoint
extends AbstractServiceTest {
    private static final String ADMIN_USER = "root1";
    private Identity adminAclIdentity;
    private String adminIdentityId;

    protected Class<?> getComponentClass() {
        return UserReputationEndpoint.class;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.startSessionAs(ADMIN_USER);
        this.registry(this.getComponentClass());
        ProgramEntity domainEntity = this.newDomain();
        this.newBadge(domainEntity.getId());
        this.newRealizationEntity("rule1", domainEntity.getId());
        this.newRealizationEntity("rule2", domainEntity.getId());
        this.newRealizationEntity("rule3", domainEntity.getId());
        this.adminAclIdentity = this.registerAdministratorUser(ADMIN_USER);
        this.adminIdentityId = this.identityManager.getOrCreateUserIdentity(ADMIN_USER).getId();
    }

    @Test
    public void testGetReputationStatus() throws Exception {
        ContainerResponse response = this.getResponse("GET", this.getURLResource("reputation/status?username=root1"), null);
        TestUserReputationEndpoint.assertNotNull((Object)response);
        TestUserReputationEndpoint.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testGetUserBadges() throws Exception {
        RuleDTO rule = this.newRuleDTO();
        RealizationDTO realization = (RealizationDTO)this.realizationService.createRealizations(rule.getEvent().getTitle(), null, this.adminIdentityId, this.adminIdentityId, "245590", "activity").getFirst();
        TestUserReputationEndpoint.assertNotNull((Object)realization);
        TestUserReputationEndpoint.assertTrue((realization.getId() > 0L ? 1 : 0) != 0);
        BadgeEntity badge = this.newBadge("Badge1", realization.getProgram().getId());
        badge.setNeededScore((int)realization.getActionScore());
        ContainerResponse response = this.getResponse("GET", this.getURLResource("reputation/badges/" + this.adminIdentityId), null);
        TestUserReputationEndpoint.assertNotNull((Object)response);
        TestUserReputationEndpoint.assertEquals((int)200, (int)response.getStatus());
        String userBadgesString = (String)response.getEntity();
        JSONArray userBadges = new JSONArray(userBadgesString);
        TestUserReputationEndpoint.assertNotNull((Object)userBadges);
        TestUserReputationEndpoint.assertTrue((userBadges.length() >= 1 ? 1 : 0) != 0);
        TestUserReputationEndpoint.assertTrue((boolean)userBadges.toList().stream().map(o -> (Map)o).map(m -> m.get("id")).anyMatch(id -> String.valueOf(id).equals(String.valueOf(badge.getId()))));
        response = this.getResponse("GET", this.getURLResource("reputation/badges"), null);
        TestUserReputationEndpoint.assertNotNull((Object)response);
        TestUserReputationEndpoint.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testGetBadgeAvatarById() throws Exception {
        ContainerResponse response = this.getResponse("GET", this.getURLResource("reputation/badge/5/avatar"), null);
        TestUserReputationEndpoint.assertNotNull((Object)response);
        TestUserReputationEndpoint.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testGetAllBadges() throws Exception {
        ContainerResponse response = this.getResponse("GET", this.getURLResource("reputation/won"), null);
        TestUserReputationEndpoint.assertNotNull((Object)response);
        TestUserReputationEndpoint.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testGetOtherBadges() throws Exception {
        this.newBadgeWithScore();
        ContainerResponse response = this.getResponse("GET", this.getURLResource("reputation/otherBadges"), null);
        TestUserReputationEndpoint.assertNotNull((Object)response);
        TestUserReputationEndpoint.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testStats() throws Exception {
        ContainerResponse response = this.getResponse("GET", this.getURLResource("reputation/stats"), null);
        TestUserReputationEndpoint.assertNotNull((Object)response);
        TestUserReputationEndpoint.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testGetAllOfBadges() throws Exception {
        ContainerResponse response = this.getResponse("GET", this.getURLResource("reputation/AllofBadges"), null);
        TestUserReputationEndpoint.assertNotNull((Object)response);
        TestUserReputationEndpoint.assertEquals((int)200, (int)response.getStatus());
    }
}

