/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.controller;

import jakarta.servlet.http.Cookie;
import java.util.List;
import java.util.Map;
import org.gatein.common.util.ParameterMap;
import org.gatein.pc.api.OpaqueStateString;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.EventInvocation;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.ResourceInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.controller.ControllerContext;
import org.gatein.pc.controller.PortletInvocationContextSupport;
import org.gatein.pc.controller.event.EventControllerContext;
import org.gatein.pc.controller.impl.state.StateControllerContextImpl;
import org.gatein.pc.controller.request.ControllerRequest;
import org.gatein.pc.controller.request.PortletActionRequest;
import org.gatein.pc.controller.state.PageNavigationalState;
import org.gatein.pc.controller.state.StateControllerContext;
import org.gatein.pc.controller.state.WindowNavigationalState;
import org.gatein.pc.portlet.support.PortletInvokerSupport;
import org.gatein.pc.portlet.support.PortletSupport;

public final class PortletControllerContextSupport
implements ControllerContext {
    private final StateControllerContext stateControllerContext = new StateControllerContextImpl();
    private EventControllerContext eventControllerContext;
    private final PortletInvokerSupport invoker = new PortletInvokerSupport();

    public PortletInvokerSupport getInvoker() {
        return this.invoker;
    }

    public PortletInfo getPortletInfo(String windowId) {
        if (windowId == null) {
            throw new IllegalArgumentException();
        }
        PortletSupport portlet = this.invoker.getPortlet(windowId);
        return portlet != null ? portlet.getInfo() : null;
    }

    public PortletInvocationContext createPortletInvocationContext(String windowId, PageNavigationalState pageNavigationalState) {
        if (windowId == null) {
            throw new IllegalArgumentException();
        }
        return new PortletInvocationContextSupport(windowId, pageNavigationalState);
    }

    private PortletInvocationResponse invoke(PortletInvocation invocation) throws PortletInvokerException {
        PortletInvocationContextSupport context = (PortletInvocationContextSupport)invocation.getContext();
        PortletContext target = PortletContext.createPortletContext((String)context.getWindowId());
        invocation.setTarget(target);
        return this.invoker.invoke(invocation);
    }

    public PortletInvocationResponse invoke(String windowId, ActionInvocation actionInvocation) throws PortletInvokerException {
        return this.invoke((PortletInvocation)actionInvocation);
    }

    public PortletInvocationResponse invoke(String windowId, List<Cookie> requestCookies, EventInvocation eventInvocation) throws PortletInvokerException {
        return this.invoke((PortletInvocation)eventInvocation);
    }

    public PortletInvocationResponse invoke(String windowId, List<Cookie> requestCookies, RenderInvocation renderInvocation) throws PortletInvokerException {
        return this.invoke((PortletInvocation)renderInvocation);
    }

    public PortletInvocationResponse invoke(String windowId, ResourceInvocation resourceInvocation) throws PortletInvokerException {
        return this.invoke((PortletInvocation)resourceInvocation);
    }

    public EventControllerContext getEventControllerContext() {
        return this.eventControllerContext;
    }

    public void setEventControllerContext(EventControllerContext eventControllerContext) {
        this.eventControllerContext = eventControllerContext;
    }

    public StateControllerContext getStateControllerContext() {
        return this.stateControllerContext;
    }

    public ControllerRequest createActionRequest(String windowId) {
        return new PortletActionRequest(windowId, (StateString)new OpaqueStateString(""), (Map)new ParameterMap(), new WindowNavigationalState(), new PageNavigationalState(true));
    }
}

