/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.gatein.pc.portlet.impl.jsr286.taglib;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.TagSupport;

public class URLProperty286Tag extends TagSupport
{
   /** The serialVersionUID */
   private static final long serialVersionUID = 1432342354333218087L;
   private String name;
   private String value;

   /**
    * The name of the property to add to the URL.
    * If null or empty, no action is performed.
    *
    * @return Returns the name.
    */
   public String getName()
   {
      return name;
   }

   /** @param name The name to set. */
   public void setName(String name)
   {
      this.name = name;
   }

   /**
    * The value of the property to add to the URL.
    * If null, it is processed as an empty value.
    *
    * @return Returns the value.
    */
   public String getValue()
   {
      return value;
   }

   /** @param value The value to set. */
   public void setValue(String value)
   {
      this.value = value;
   }

   /**
    * No body to process
    *
    * @see jakarta.servlet.jsp.tagext.Tag#doStartTag()
    */
   public int doStartTag() throws JspException
   {
      return SKIP_BODY;
   }

   /**
    * Include the property in the surround tag properties
    *
    * @see jakarta.servlet.jsp.tagext.Tag#doEndTag()
    */
   public int doEndTag() throws JspException
   {
      try
      {
         GenerateURL286Tag ancestorTag =
            (GenerateURL286Tag)findAncestorWithClass(this, GenerateURL286Tag.class);

         Property p = new Property(getName(), getValue());

         if (p.isValid())
         {
            ancestorTag.addProperty(p.getName(), p.getValue());
         }
         else
         {
            // Should throw a JspException?
            // Not according to the JSR 286 spec. Ignore it
         }

      }
      catch (Exception e)
      {
         e.printStackTrace();
         throw new JspException(e);
      }
      return EVAL_PAGE;
   }

   public class Property
   {
      private String name;
      private String value;

      /** @return Returns the name. */
      public String getName()
      {
         return name;
      }

      /**
       * Per JSR 286 spec, if null, return an empty value
       *
       * @return Returns the value.
       */
      public String getValue()
      {
         return value;
      }

      public Property(String name, String value)
      {
         this.name = name;
         this.value = value;
      }

      public boolean isValid()
      {
         return name != null && name.length() > 0;
      }
   }

}
