/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.gatein.pc.test.portlet.jsr168.api.portletconfig;

import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.web.AbstractUniversalTestPortlet;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.web.UTP1;
import org.gatein.pc.test.unit.web.UTP2;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import static org.gatein.pc.test.unit.Assert.assertNotNull;
import static org.gatein.pc.test.unit.Assert.assertTrue;
import static org.gatein.pc.test.unit.Assert.assertEquals;

import javax.portlet.Portlet;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.PortletConfig;
import java.util.Enumeration;
import java.util.List;
import java.util.LinkedList;

@TestCase({Assertion.API286_PORTLET_CONFIG_4})
public class InitParameterNames
{
   public InitParameterNames(PortletTestCase seq)
   {
      seq.bindAction(0, UTP1.RENDER_JOIN_POINT, new PortletRenderTestAction()
      {
         protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context)
         {
            AbstractUniversalTestPortlet aport = (AbstractUniversalTestPortlet)portlet;
            PortletConfig config = aport.getPortletConfig();

            assertNotNull(config);
            Enumeration e = config.getInitParameterNames();

            //should be EMPTY
            assertTrue(!e.hasMoreElements());

            //we do nothing. response will be rendered by other portlet. If failed there will be
            //two results so whole test case will fail;
            return null;
         }
      });

      seq.bindAction(0, UTP2.RENDER_JOIN_POINT, new PortletRenderTestAction()
      {
         protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context)
         {
            AbstractUniversalTestPortlet aport = (AbstractUniversalTestPortlet)portlet;
            PortletConfig config = aport.getPortletConfig();

            assertNotNull(config);

            Enumeration enumer = config.getInitParameterNames();
            //construct list from names enumeration
            List names = new LinkedList();

            while (enumer.hasMoreElements())
            {
               names.add(enumer.nextElement());
            }

            //assert it contains correct names
            assertEquals(2, names.size());

            assertTrue(names.contains("InitParamA"));
            assertTrue(names.contains("InitParamB"));

            return new EndTestResponse();
         }
      });
   }
}
