/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.gatein.pc.test.portlet.jsr168.api.portletpreferences;

import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.actions.PortletActionTestAction;
import org.gatein.pc.test.unit.web.UTP2;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import static org.gatein.pc.test.unit.Assert.assertEquals;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;

import javax.portlet.Portlet;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletURL;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import java.io.IOException;

@TestCase({
   Assertion.API286_PORTLET_PREFERENCES_3,
   Assertion.API286_PORTLET_PREFERENCES_4
   })
public class ZeroLengthArrayValue
{
   public ZeroLengthArrayValue(PortletTestCase seq)
   {
      seq.bindAction(0, UTP2.RENDER_JOIN_POINT, new PortletRenderTestAction()
      {
         protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context)
         {
            PortletPreferences prefs = request.getPreferences();

            // With the default value coming from the portlet.xml descriptor
            String value = prefs.getValue("empty", "other");
            assertEquals("other", value);
            assertEquals(new String[]{"other"}, prefs.getValues("empty", new String[]{"other"}));

            //
            PortletURL url = response.createActionURL();
            return new InvokeGetResponse(url.toString());
         }
      });
      seq.bindAction(1, UTP2.ACTION_JOIN_POINT, new PortletActionTestAction()
      {
         protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) throws ReadOnlyException, IOException, ValidatorException
         {
            PortletPreferences prefs = request.getPreferences();

            // Check it does not exist yet
            assertEquals("other", prefs.getValue("dynamic", "other"));
            assertEquals(new String[]{"other"}, prefs.getValues("dynamic", new String[]{"other"}));

            // Set the value to the empty array and check we get the other value
            prefs.setValues("dynamic", new String[0]);
            assertEquals("other", prefs.getValue("dynamic", "other"));
            assertEquals(new String[]{"other"}, prefs.getValues("dynamic", new String[]{"other"}));

            // Commit change
            prefs.store();

            // Check we still have the other value
            assertEquals("other", prefs.getValue("dynamic", "other"));
            assertEquals(new String[]{"other"}, prefs.getValues("dynamic", new String[]{"other"}));
         }
      });
      seq.bindAction(1, UTP2.RENDER_JOIN_POINT, new PortletRenderTestAction()
      {
         protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context)
         {
            PortletPreferences prefs = request.getPreferences();

            // Check we still have the other value
            assertEquals("other", prefs.getValue("dynamic", "other"));
            assertEquals(new String[]{"other"}, prefs.getValues("dynamic", new String[]{"other"}));

            //
            return new EndTestResponse();
         }
      });
   }
}
