/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.gatein.pc.embed.xmlescaping;

import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import java.io.IOException;
import java.io.PrintWriter;

/**/
public class XmlEscapingPortlet extends GenericPortlet
{

   /** . */
   static int count;

   @Override
   protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException
   {
      PortletURL url = response.createActionURL();
      url.setParameter("foo", "foo_value");
      url.setParameter("bar", "bar_value");
      response.setContentType("text/html");
      PrintWriter writer = response.getWriter();
      writer.print("FOO");
      url.write(writer);
      writer.print("FOO");
      writer.print("FOO");
      url.write(writer, false);
      writer.print("FOO");
      writer.print("FOO");
      url.write(writer, true);
      writer.print("FOO");
      writer.close();
      count++;
   }
}
