/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.EventInvocation;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.ResourceInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.portlet.support.info.PortletInfoSupport;

public final class PortletSupport
implements Portlet {
    private final PortletContext portletContext;
    boolean valid;
    final Map<String, List<String>> state;
    private int invocationCount;
    private final ArrayList<InvocationHandler> handlers = new ArrayList();
    private final PortletInfoSupport info;

    public PortletSupport(String portletId, PortletInfoSupport info) {
        if (portletId == null) {
            throw new IllegalArgumentException();
        }
        if (info == null) {
            throw new IllegalArgumentException();
        }
        this.portletContext = PortletContext.createPortletContext((String)portletId);
        this.valid = true;
        this.state = new HashMap<String, List<String>>();
        this.info = info;
    }

    public void addPreference(String key, List<String> value) {
        this.info.getPreferences().addPreference(key);
        this.state.put(key, value);
    }

    public void addPreference(String key, List<String> value, Boolean readOnly) {
        this.info.getPreferences().addPreference(key, readOnly);
        this.state.put(key, value);
    }

    public int getInvocationCount() {
        return this.invocationCount;
    }

    public void addHandler(InvocationHandler handler) {
        this.handlers.add(handler);
    }

    public void assertInvocationCountIs(int expectedInvocationCount) {
        Assert.assertEquals((int)expectedInvocationCount, (int)this.invocationCount);
    }

    public PortletInvocationResponse invoke(PortletInvocation invocation) throws PortletInvokerException {
        Assert.assertNotNull((Object)invocation);
        if (this.invocationCount == this.handlers.size()) {
            throw new AssertionError();
        }
        InvocationHandler handler = this.handlers.get(this.invocationCount++);
        return handler.invoke(invocation);
    }

    public PortletContext getContext() {
        return this.portletContext;
    }

    public PortletInfoSupport getInfo() {
        return this.info;
    }

    public boolean isRemote() {
        return false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public static class InvocationHandler {
        protected PortletInvocationResponse invoke(PortletInvocation invocation) throws PortletInvokerException {
            throw new PortletInvokerException("No implementations");
        }
    }

    public static abstract class ResourceHandler
    extends InvocationHandler {
        @Override
        protected final PortletInvocationResponse invoke(PortletInvocation invocation) throws PortletInvokerException {
            if (invocation instanceof ResourceInvocation) {
                return this.invoke((ResourceInvocation)invocation);
            }
            throw new AssertionError();
        }

        protected abstract PortletInvocationResponse invoke(ResourceInvocation var1) throws PortletInvokerException;
    }

    public static abstract class RenderHandler
    extends InvocationHandler {
        @Override
        protected final PortletInvocationResponse invoke(PortletInvocation invocation) throws PortletInvokerException {
            if (invocation instanceof RenderInvocation) {
                return this.invoke((RenderInvocation)invocation);
            }
            throw new AssertionError();
        }

        protected abstract PortletInvocationResponse invoke(RenderInvocation var1) throws PortletInvokerException;
    }

    public static abstract class EventHandler
    extends InvocationHandler {
        @Override
        protected final PortletInvocationResponse invoke(PortletInvocation invocation) throws PortletInvokerException {
            if (invocation instanceof EventInvocation) {
                return this.invoke((EventInvocation)invocation);
            }
            throw new AssertionError();
        }

        protected abstract PortletInvocationResponse invoke(EventInvocation var1) throws PortletInvokerException;
    }

    public static abstract class ActionHandler
    extends InvocationHandler {
        @Override
        protected final PortletInvocationResponse invoke(PortletInvocation invocation) throws PortletInvokerException {
            if (invocation instanceof ActionInvocation) {
                return this.invoke((ActionInvocation)invocation);
            }
            throw new AssertionError();
        }

        protected abstract PortletInvocationResponse invoke(ActionInvocation var1) throws PortletInvokerException;
    }
}

