/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.container;

import junit.framework.TestCase;
import org.gatein.pc.portlet.container.ManagedObjectRegistryEventList;
import org.gatein.pc.portlet.container.ObjectSupport;
import org.gatein.pc.portlet.container.PortletApplicationContext;
import org.gatein.pc.portlet.container.PortletApplicationContextSupport;
import org.gatein.pc.portlet.container.PortletApplicationObjectSupport;
import org.gatein.pc.portlet.container.PortletContainerContext;
import org.gatein.pc.portlet.container.PortletContainerContextSupport;
import org.gatein.pc.portlet.container.PortletContainerObjectSupport;
import org.gatein.pc.portlet.container.PortletFilterContext;
import org.gatein.pc.portlet.container.PortletFilterContextSupport;
import org.gatein.pc.portlet.container.PortletFilterObjectSupport;
import org.gatein.pc.portlet.container.managed.LifeCycleStatus;
import org.gatein.pc.portlet.container.managed.ManagedObject;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEventListener;
import org.gatein.pc.portlet.container.object.PortletApplicationObject;
import org.gatein.pc.portlet.container.object.PortletContainerObject;
import org.gatein.pc.portlet.container.object.PortletFilterObject;
import org.gatein.pc.portlet.impl.container.PortletApplicationLifeCycle;
import org.gatein.pc.portlet.impl.container.PortletContainerLifeCycle;
import org.gatein.pc.portlet.impl.container.PortletFilterLifeCycle;

public class LifeCycle1TestCase
extends TestCase {
    ManagedObjectRegistryEventList events;
    PortletApplicationObjectSupport application;
    PortletApplicationLifeCycle applicationLC;
    PortletFilterObjectSupport filter;
    PortletContainerObjectSupport container;
    PortletFilterLifeCycle filterLC;
    PortletContainerLifeCycle containerLC;

    protected void setUp() throws Exception {
        this.events = new ManagedObjectRegistryEventList();
        this.application = new PortletApplicationObjectSupport("application");
        this.applicationLC = new PortletApplicationLifeCycle((ManagedObjectRegistryEventListener)this.events, (PortletApplicationContext)new PortletApplicationContextSupport(), (PortletApplicationObject)this.application);
        this.filter = new PortletFilterObjectSupport("filter2");
        this.container = new PortletContainerObjectSupport("container2");
        this.filterLC = this.applicationLC.addPortletFilter((PortletFilterContext)new PortletFilterContextSupport(), (PortletFilterObject)this.filter);
        this.containerLC = this.applicationLC.addPortletContainer((PortletContainerContext)new PortletContainerContextSupport(), (PortletContainerObject)this.container);
        this.applicationLC.addDependency(this.filterLC, this.containerLC);
        this.applicationLC.create();
    }

    private void testState(int applicationStarted, int applicationStopped, LifeCycleStatus applicationStatus, Throwable applicationFailure, int containerStarted, int containerStopped, LifeCycleStatus containerStatus, Throwable containerFailure, int filterStarted, int filterStopped, LifeCycleStatus filterStatus, Throwable filterFailure) {
        LifeCycle1TestCase.assertEquals((int)applicationStarted, (int)this.application.getStarted());
        LifeCycle1TestCase.assertEquals((int)applicationStopped, (int)this.application.getStopped());
        LifeCycle1TestCase.assertEquals((Object)applicationStatus, (Object)this.applicationLC.getStatus());
        LifeCycle1TestCase.assertSame((Object)applicationFailure, (Object)this.applicationLC.getFailure());
        LifeCycle1TestCase.assertEquals((int)containerStarted, (int)this.container.getStarted());
        LifeCycle1TestCase.assertEquals((int)containerStopped, (int)this.container.getStopped());
        LifeCycle1TestCase.assertEquals((Object)containerStatus, (Object)this.containerLC.getStatus());
        LifeCycle1TestCase.assertSame((Object)containerFailure, (Object)this.containerLC.getFailure());
        LifeCycle1TestCase.assertEquals((int)filterStarted, (int)this.filter.getStarted());
        LifeCycle1TestCase.assertEquals((int)filterStopped, (int)this.filter.getStopped());
        LifeCycle1TestCase.assertEquals((Object)filterStatus, (Object)this.filterLC.getStatus());
        LifeCycle1TestCase.assertSame((Object)filterFailure, (Object)this.filterLC.getFailure());
    }

    public void testWiring() {
        this.events.assertAddedEvent((ManagedObject)this.filterLC);
        this.events.assertAddedEvent((ManagedObject)this.containerLC);
        this.events.assertEmpty();
        LifeCycle1TestCase.assertEquals((int)1, (int)this.application.containers.size());
        LifeCycle1TestCase.assertSame((Object)this.container, (Object)this.application.containers.get(this.container.getId()));
        LifeCycle1TestCase.assertEquals((int)1, (int)this.application.filters.size());
        LifeCycle1TestCase.assertSame((Object)this.filter, (Object)this.application.filters.get(this.filter.getId()));
        LifeCycle1TestCase.assertSame((Object)this.application, (Object)this.filter.application);
        LifeCycle1TestCase.assertSame((Object)this.application, (Object)this.container.application);
        LifeCycle1TestCase.assertEquals((int)1, (int)this.container.filters.size());
        LifeCycle1TestCase.assertSame((Object)this.filter, (Object)this.container.filters.get(this.filter.getId()));
    }

    public void testApplicationLifeCycle() {
        this.events.clear();
        this.applicationLC.managedStart();
        this.testState(1, 0, LifeCycleStatus.STARTED, null, 1, 0, LifeCycleStatus.STARTED, null, 1, 0, LifeCycleStatus.STARTED, null);
        this.events.assertCreatedEvent((ManagedObject)this.applicationLC);
        this.events.assertStartedEvent((ManagedObject)this.applicationLC);
        this.events.assertCreatedEvent((ManagedObject)this.filterLC);
        this.events.assertStartedEvent((ManagedObject)this.filterLC);
        this.events.assertCreatedEvent((ManagedObject)this.containerLC);
        this.events.assertStartedEvent((ManagedObject)this.containerLC);
        this.events.assertEmpty();
        this.applicationLC.managedStart();
        this.testState(1, 0, LifeCycleStatus.STARTED, null, 1, 0, LifeCycleStatus.STARTED, null, 1, 0, LifeCycleStatus.STARTED, null);
        this.events.assertEmpty();
        this.applicationLC.managedDestroy();
        this.testState(1, 1, LifeCycleStatus.INITIALIZED, null, 1, 1, LifeCycleStatus.INITIALIZED, null, 1, 1, LifeCycleStatus.INITIALIZED, null);
        this.events.assertStoppedEvent((ManagedObject)this.containerLC);
        this.events.assertDestroyedEvent((ManagedObject)this.containerLC);
        this.events.assertStoppedEvent((ManagedObject)this.filterLC);
        this.events.assertDestroyedEvent((ManagedObject)this.filterLC);
        this.events.assertStoppedEvent((ManagedObject)this.applicationLC);
        this.events.assertDestroyedEvent((ManagedObject)this.applicationLC);
        this.events.assertEmpty();
    }

    public void testFilterLifeCycle() {
        this.events.clear();
        this.applicationLC.managedStart();
        this.events.clear();
        this.filterLC.managedDestroy();
        this.testState(1, 0, LifeCycleStatus.STARTED, null, 1, 1, LifeCycleStatus.INITIALIZED, null, 1, 1, LifeCycleStatus.INITIALIZED, null);
        this.events.assertStoppedEvent((ManagedObject)this.containerLC);
        this.events.assertDestroyedEvent((ManagedObject)this.containerLC);
        this.events.assertStoppedEvent((ManagedObject)this.filterLC);
        this.events.assertDestroyedEvent((ManagedObject)this.filterLC);
        this.events.assertEmpty();
        this.containerLC.managedStart();
        this.testState(1, 0, LifeCycleStatus.STARTED, null, 1, 1, LifeCycleStatus.INITIALIZED, null, 1, 1, LifeCycleStatus.INITIALIZED, null);
        this.events.assertEmpty();
        this.filterLC.managedStart();
        this.testState(1, 0, LifeCycleStatus.STARTED, null, 2, 1, LifeCycleStatus.STARTED, null, 2, 1, LifeCycleStatus.STARTED, null);
        this.events.assertCreatedEvent((ManagedObject)this.filterLC);
        this.events.assertStartedEvent((ManagedObject)this.filterLC);
        this.events.assertCreatedEvent((ManagedObject)this.containerLC);
        this.events.assertStartedEvent((ManagedObject)this.containerLC);
        this.events.assertEmpty();
    }

    public void testContainerLifeCycle() {
        this.events.clear();
        this.applicationLC.managedStart();
        this.events.clear();
        this.containerLC.managedDestroy();
        this.testState(1, 0, LifeCycleStatus.STARTED, null, 1, 1, LifeCycleStatus.INITIALIZED, null, 1, 0, LifeCycleStatus.STARTED, null);
        this.events.assertStoppedEvent((ManagedObject)this.containerLC);
        this.events.assertDestroyedEvent((ManagedObject)this.containerLC);
        this.events.assertEmpty();
        this.containerLC.managedStart();
        this.testState(1, 0, LifeCycleStatus.STARTED, null, 2, 1, LifeCycleStatus.STARTED, null, 1, 0, LifeCycleStatus.STARTED, null);
        this.events.assertCreatedEvent((ManagedObject)this.containerLC);
        this.events.assertStartedEvent((ManagedObject)this.containerLC);
        this.events.assertEmpty();
    }

    public void testContainerFailsOnStart() {
        this.events.clear();
        ObjectSupport.Failure failure = new ObjectSupport.Failure();
        this.container.startCallback = failure;
        this.applicationLC.managedStart();
        this.testState(1, 0, LifeCycleStatus.STARTED, null, 1, 0, LifeCycleStatus.CREATED, this.containerLC.getFailure(), 1, 0, LifeCycleStatus.STARTED, null);
        this.events.assertCreatedEvent((ManagedObject)this.applicationLC);
        this.events.assertStartedEvent((ManagedObject)this.applicationLC);
        this.events.assertCreatedEvent((ManagedObject)this.filterLC);
        this.events.assertStartedEvent((ManagedObject)this.filterLC);
        this.events.assertCreatedEvent((ManagedObject)this.containerLC);
        this.events.assertFailedEvent((ManagedObject)this.containerLC);
        this.events.assertEmpty();
        this.applicationLC.managedDestroy();
        this.testState(1, 1, LifeCycleStatus.INITIALIZED, null, 1, 0, LifeCycleStatus.INITIALIZED, null, 1, 1, LifeCycleStatus.INITIALIZED, null);
        this.events.assertDestroyedEvent((ManagedObject)this.containerLC);
        this.events.assertStoppedEvent((ManagedObject)this.filterLC);
        this.events.assertDestroyedEvent((ManagedObject)this.filterLC);
        this.events.assertStoppedEvent((ManagedObject)this.applicationLC);
        this.events.assertDestroyedEvent((ManagedObject)this.applicationLC);
        this.events.assertEmpty();
        this.applicationLC.managedStart();
        this.testState(2, 1, LifeCycleStatus.STARTED, null, 2, 0, LifeCycleStatus.CREATED, this.containerLC.getFailure(), 2, 1, LifeCycleStatus.STARTED, null);
        this.events.assertCreatedEvent((ManagedObject)this.applicationLC);
        this.events.assertStartedEvent((ManagedObject)this.applicationLC);
        this.events.assertCreatedEvent((ManagedObject)this.filterLC);
        this.events.assertStartedEvent((ManagedObject)this.filterLC);
        this.events.assertCreatedEvent((ManagedObject)this.containerLC);
        this.events.assertFailedEvent((ManagedObject)this.containerLC);
        this.events.assertEmpty();
        this.containerLC.managedStart();
        this.testState(2, 1, LifeCycleStatus.STARTED, null, 3, 0, LifeCycleStatus.CREATED, failure.getFailure(), 2, 1, LifeCycleStatus.STARTED, null);
        this.events.assertFailedEvent((ManagedObject)this.containerLC);
        this.events.assertEmpty();
        this.containerLC.managedDestroy();
        this.testState(2, 1, LifeCycleStatus.STARTED, null, 3, 0, LifeCycleStatus.INITIALIZED, null, 2, 1, LifeCycleStatus.STARTED, null);
        this.events.assertDestroyedEvent((ManagedObject)this.containerLC);
        this.events.assertEmpty();
        this.filterLC.managedDestroy();
        this.testState(2, 1, LifeCycleStatus.STARTED, null, 3, 0, LifeCycleStatus.INITIALIZED, null, 2, 2, LifeCycleStatus.INITIALIZED, null);
        this.events.assertStoppedEvent((ManagedObject)this.filterLC);
        this.events.assertDestroyedEvent((ManagedObject)this.filterLC);
        this.events.assertEmpty();
        this.filterLC.managedStart();
        this.testState(2, 1, LifeCycleStatus.STARTED, null, 4, 0, LifeCycleStatus.CREATED, failure.getFailure(), 3, 2, LifeCycleStatus.STARTED, null);
        this.events.assertCreatedEvent((ManagedObject)this.filterLC);
        this.events.assertStartedEvent((ManagedObject)this.filterLC);
        this.events.assertCreatedEvent((ManagedObject)this.containerLC);
        this.events.assertFailedEvent((ManagedObject)this.containerLC);
        this.events.assertEmpty();
    }

    public void testApplicationFailsOnStart() {
        this.events.clear();
        ObjectSupport.Failure failure = new ObjectSupport.Failure();
        this.application.startCallback = failure;
        this.applicationLC.managedStart();
        this.testState(1, 0, LifeCycleStatus.CREATED, this.applicationLC.getFailure(), 0, 0, LifeCycleStatus.CREATED, null, 0, 0, LifeCycleStatus.CREATED, null);
        this.events.assertCreatedEvent((ManagedObject)this.applicationLC);
        this.events.assertFailedEvent((ManagedObject)this.applicationLC);
        this.events.assertCreatedEvent((ManagedObject)this.filterLC);
        this.events.assertCreatedEvent((ManagedObject)this.containerLC);
        this.events.assertEmpty();
        this.applicationLC.managedStart();
        this.testState(2, 0, LifeCycleStatus.CREATED, failure.getFailure(), 0, 0, LifeCycleStatus.CREATED, null, 0, 0, LifeCycleStatus.CREATED, null);
        this.events.assertFailedEvent((ManagedObject)this.applicationLC);
        this.events.assertEmpty();
        this.applicationLC.managedDestroy();
        this.testState(2, 0, LifeCycleStatus.INITIALIZED, null, 0, 0, LifeCycleStatus.INITIALIZED, null, 0, 0, LifeCycleStatus.INITIALIZED, null);
        this.events.assertDestroyedEvent((ManagedObject)this.containerLC);
        this.events.assertDestroyedEvent((ManagedObject)this.filterLC);
        this.events.assertDestroyedEvent((ManagedObject)this.applicationLC);
        this.events.assertEmpty();
    }

    public void testFilterFailsOnStart() {
        this.events.clear();
        ObjectSupport.Failure failure = new ObjectSupport.Failure();
        this.filter.startCallback = failure;
        this.applicationLC.managedStart();
        this.testState(1, 0, LifeCycleStatus.STARTED, null, 0, 0, LifeCycleStatus.CREATED, null, 1, 0, LifeCycleStatus.CREATED, this.filterLC.getFailure());
        this.events.assertCreatedEvent((ManagedObject)this.applicationLC);
        this.events.assertStartedEvent((ManagedObject)this.applicationLC);
        this.events.assertCreatedEvent((ManagedObject)this.filterLC);
        this.events.assertFailedEvent((ManagedObject)this.filterLC);
        this.events.assertCreatedEvent((ManagedObject)this.containerLC);
        this.events.assertEmpty();
        this.applicationLC.managedDestroy();
        this.testState(1, 1, LifeCycleStatus.INITIALIZED, null, 0, 0, LifeCycleStatus.INITIALIZED, null, 1, 0, LifeCycleStatus.INITIALIZED, null);
        this.events.assertDestroyedEvent((ManagedObject)this.containerLC);
        this.events.assertDestroyedEvent((ManagedObject)this.filterLC);
        this.events.assertStoppedEvent((ManagedObject)this.applicationLC);
        this.events.assertDestroyedEvent((ManagedObject)this.applicationLC);
        this.events.assertEmpty();
        this.applicationLC.managedStart();
        this.testState(2, 1, LifeCycleStatus.STARTED, null, 0, 0, LifeCycleStatus.CREATED, null, 2, 0, LifeCycleStatus.CREATED, failure.getFailure());
        this.events.assertCreatedEvent((ManagedObject)this.applicationLC);
        this.events.assertStartedEvent((ManagedObject)this.applicationLC);
        this.events.assertCreatedEvent((ManagedObject)this.filterLC);
        this.events.assertFailedEvent((ManagedObject)this.filterLC);
        this.events.assertCreatedEvent((ManagedObject)this.containerLC);
        this.events.assertEmpty();
        this.filterLC.managedStart();
        this.testState(2, 1, LifeCycleStatus.STARTED, null, 0, 0, LifeCycleStatus.CREATED, null, 3, 0, LifeCycleStatus.CREATED, failure.getFailure());
        this.events.assertFailedEvent((ManagedObject)this.filterLC);
        this.events.assertEmpty();
        this.filterLC.managedDestroy();
        this.testState(2, 1, LifeCycleStatus.STARTED, null, 0, 0, LifeCycleStatus.INITIALIZED, null, 3, 0, LifeCycleStatus.INITIALIZED, null);
        this.events.assertDestroyedEvent((ManagedObject)this.containerLC);
        this.events.assertDestroyedEvent((ManagedObject)this.filterLC);
        this.events.assertEmpty();
        this.filterLC.managedStart();
        this.testState(2, 1, LifeCycleStatus.STARTED, null, 0, 0, LifeCycleStatus.CREATED, null, 4, 0, LifeCycleStatus.CREATED, failure.getFailure());
        this.events.assertCreatedEvent((ManagedObject)this.filterLC);
        this.events.assertFailedEvent((ManagedObject)this.filterLC);
        this.events.assertCreatedEvent((ManagedObject)this.containerLC);
        this.events.assertEmpty();
        this.containerLC.managedStart();
        this.testState(2, 1, LifeCycleStatus.STARTED, null, 0, 0, LifeCycleStatus.CREATED, null, 4, 0, LifeCycleStatus.CREATED, failure.getFailure());
        this.events.assertEmpty();
    }

    public void testContainerFailsOnStop() {
        this.container.stopCallback = new ObjectSupport.Failure();
        this.testApplicationLifeCycle();
    }

    public void testApplicationFailsOnStop() {
        this.application.stopCallback = new ObjectSupport.Failure();
        this.testApplicationLifeCycle();
    }

    public void testFilterFailsOnStop() {
        this.filter.stopCallback = new ObjectSupport.Failure();
        this.testApplicationLifeCycle();
    }
}

