/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.unit;

import jakarta.servlet.http.Cookie;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.common.util.Tools;
import org.gatein.pc.test.unit.Assert;

public abstract class TestAction {
    private Log log = null;

    protected final Log getLogger() {
        if (this.log == null) {
            this.log = ExoLogger.getLogger(this.getClass());
        }
        return this.log;
    }

    protected final void assertParameterMap(Map<String, String[]> expectedMap, PortletRequest request) throws AssertionError {
        Assert.assertNotNull(request);
        for (Map.Entry<String, String[]> entry : expectedMap.entrySet()) {
            String expectedValue = entry.getValue()[0];
            String actualValue = request.getParameter(entry.getKey());
            Assert.assertEquals("Was expecting value " + expectedValue + " for key " + entry.getKey() + " but instead have " + actualValue, expectedValue, actualValue);
        }
        for (Map.Entry<String, String[]> entry : expectedMap.entrySet()) {
            Object[] expectedValues = entry.getValue();
            Assert.assertEquals(expectedValues, request.getParameterValues(entry.getKey()));
        }
        List names = Tools.toList((Enumeration)request.getParameterNames());
        ArrayList<String> expectedNames = new ArrayList<String>(expectedMap.keySet());
        Collections.sort(names);
        Collections.sort(expectedNames);
        Assert.assertEquals(expectedNames, names);
        Map map = request.getParameterMap();
        this.assertParameterMap(expectedMap, map);
    }

    protected final void assertParameterMap(Map<String, String[]> expectedMap, Map<String, String[]> map) throws AssertionError {
        Assert.assertNotNull(map);
        Assert.assertEquals(expectedMap.keySet(), map.keySet());
        for (Map.Entry<String, String[]> entry : expectedMap.entrySet()) {
            Object[] expectedValues = map.get(entry.getKey());
            Assert.assertEquals(entry.getValue(), expectedValues);
        }
    }

    protected final Map<String, String> createCookieMap(PortletRequest request) {
        HashMap<String, String> cookieMap = new HashMap<String, String>();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                cookieMap.put(cookie.getName(), cookie.getValue());
            }
        }
        return cookieMap;
    }
}

