/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr168.ext.session;

import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionBindingListener;
import java.io.IOException;
import java.io.Serializable;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.UTP1;

@TestCase(value={Assertion.EXT_SESSION_2})
public class HTTPSessionInvalidationInvalidesPortletSession
implements Serializable {
    private static final long serialVersionUID = -4129569056920464851L;

    public HTTPSessionInvalidationInvalidesPortletSession(PortletTestCase seq) {
        seq.bindAction(0, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException {
                PortletSession session = request.getPortletSession();
                SessionInvalidator invalidator = new SessionInvalidator();
                invalidator.invalidate(session);
                session = request.getPortletSession(false);
                Assert.assertNull((Object)session);
                return new EndTestResponse();
            }
        });
    }

    private static class SessionInvalidator
    implements HttpSessionBindingListener,
    Serializable {
        private static final long serialVersionUID = -4844795605278357322L;
        private HttpSession realSession;

        private SessionInvalidator() {
        }

        public void valueBound(HttpSessionBindingEvent event) {
            this.realSession = event.getSession();
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
        }

        public void invalidate(PortletSession session) {
            session.setAttribute("foo", (Object)this);
            this.realSession.invalidate();
        }
    }
}

