/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.unit;

import org.gatein.pc.test.unit.JoinPointType;
import org.gatein.pc.test.unit.annotations.TestActor;

public class JoinPoint {
    private final String actorId;
    private final JoinPointType type;

    public JoinPoint(String actorId, JoinPointType type) {
        if (actorId == null) {
            throw new IllegalArgumentException("Actor id value cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        this.actorId = actorId;
        this.type = type;
    }

    public String getActorId() {
        return this.actorId;
    }

    public JoinPointType getType() {
        return this.type;
    }

    public int hashCode() {
        return this.actorId.hashCode() * 43 + this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JoinPoint)) {
            throw new IllegalArgumentException("Cannot compare with different object class");
        }
        JoinPoint j = (JoinPoint)obj;
        return this.actorId.equals(j.actorId) && this.type == j.type;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[actor=" + this.actorId + ",type=" + String.valueOf((Object)this.type) + "]";
    }

    public static JoinPoint createJoinPoint(Class annotatedClass, JoinPointType type) {
        TestActor testActorAnnotation = annotatedClass.getAnnotation(TestActor.class);
        if (testActorAnnotation == null) {
            throw new IllegalStateException("No annotation @TestPortlet found on portlet class " + annotatedClass.getName());
        }
        String actorId = testActorAnnotation.id();
        return new JoinPoint(actorId, type);
    }
}

