/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.unit.protocol;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class Body
implements Serializable {

    public static class Form
    extends Body {
        private Map<String, String[]> parameters = new HashMap<String, String[]>();

        public void addParameter(String name, String[] values) {
            if (name == null) {
                throw new IllegalStateException();
            }
            if (values == null) {
                throw new IllegalStateException();
            }
            for (String value : values) {
                if (value != null) continue;
                throw new IllegalStateException();
            }
            this.parameters.put(name, (String[])values.clone());
        }

        public void removeParameter(String name) {
            if (name == null) {
                throw new IllegalStateException();
            }
            this.parameters.remove(name);
        }

        public Set getParameterNames() {
            return Collections.unmodifiableSet(this.parameters.keySet());
        }

        public String[] getParameterValues(String name) {
            if (name == null) {
                throw new IllegalStateException();
            }
            String[] values = this.parameters.get(name);
            return values != null ? (String[])values.clone() : null;
        }
    }

    public static class Raw
    extends Body {
        private byte[] bytes;

        public byte[] getBytes() {
            return this.bytes;
        }

        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }
    }
}

