/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr286.ext.dispatcher;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.JoinPoint;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.actions.ServletServiceTestAction;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.AbstractUniversalTestPortlet;
import org.gatein.pc.test.unit.web.UTS1;

public abstract class AbstractDispatchedSession {
    public AbstractDispatchedSession(PortletTestCase seq, JoinPoint portletJoinPoint, final int sessionScope) {
        seq.bindAction(0, portletJoinPoint, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException {
                PortletRequestDispatcher dispatcher = ((AbstractUniversalTestPortlet)portlet).getPortletContext().getNamedDispatcher("UniversalServletA");
                Assert.assertNotNull((Object)dispatcher);
                dispatcher.include(request, response);
                PortletSession session = request.getPortletSession(false);
                Assert.assertNotNull((Object)session);
                Assert.assertTrue((boolean)session.isNew());
                Object value = session.getAttribute("foo", sessionScope);
                Assert.assertEquals((Object)"foo_dispatched_value", (Object)value);
                return new InvokeGetResponse(response.createRenderURL().toString());
            }
        });
        seq.bindAction(0, UTS1.SERVICE_JOIN_POINT, (TestAction)new ServletServiceTestAction(this){

            public Response execute(Servlet servlet, HttpServletRequest request, HttpServletResponse response, PortletTestContext context) throws ServletException, IOException {
                HttpSession session = request.getSession(false);
                Assert.assertNull((Object)session);
                session = request.getSession();
                Assert.assertNotNull((Object)session);
                Assert.assertTrue((boolean)session.isNew());
                session.setAttribute("foo", (Object)"foo_dispatched_value");
                Assert.assertEquals((Object)"foo_dispatched_value", (Object)session.getAttribute("foo"));
                return null;
            }
        });
        seq.bindAction(1, portletJoinPoint, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException {
                PortletSession session = request.getPortletSession(false);
                Assert.assertNotNull((Object)session);
                Assert.assertFalse((boolean)session.isNew());
                Assert.assertEquals((Object)"foo_dispatched_value", (Object)session.getAttribute("foo", sessionScope));
                PortletRequestDispatcher dispatcher = ((AbstractUniversalTestPortlet)portlet).getPortletContext().getNamedDispatcher("UniversalServletA");
                Assert.assertNotNull((Object)dispatcher);
                dispatcher.include(request, response);
                try {
                    session.isNew();
                    Assert.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                return new EndTestResponse();
            }
        });
        seq.bindAction(1, UTS1.SERVICE_JOIN_POINT, (TestAction)new ServletServiceTestAction(this){

            public Response execute(Servlet servlet, HttpServletRequest request, HttpServletResponse response, PortletTestContext context) throws ServletException, IOException {
                HttpSession session = request.getSession(false);
                Assert.assertNotNull((Object)session);
                Assert.assertFalse((boolean)session.isNew());
                Assert.assertEquals((Object)"foo_dispatched_value", (Object)session.getAttribute("foo"));
                session.invalidate();
                try {
                    session.isNew();
                    Assert.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                return null;
            }
        });
    }
}

