/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.unit;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.gatein.pc.test.unit.protocol.Conversation;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractWarTestCase {
    @ArquillianResource
    protected URL deploymentURL;
    @ArquillianResource
    Deployer deployer;
    private final String version;
    private final String type;
    private final String suite;
    private final String name;
    private final String[] deployments;

    @Deployment(name="portal", testable=false, order=1)
    public static WebArchive createDeployment() throws Exception {
        WebArchive war = (WebArchive)ShrinkWrap.create(WebArchive.class);
        war.addAsWebInfResource("portal-war/WEB-INF/web.xml");
        return war;
    }

    public static WebArchive createDeployment(String version, String type, String suite) throws Exception {
        WebArchive war = (WebArchive)ShrinkWrap.create(WebArchive.class);
        war.addPackages(true, new String[]{"org/gatein/pc/test/portlet/" + version + "/" + type + "/common"});
        war.addPackages(true, new String[]{"org/gatein/pc/test/portlet/" + version + "/common"});
        war.addPackages(true, new String[]{"org/gatein/pc/test/portlet/common"});
        war.addPackages(true, new String[]{"org/gatein/pc/test/portlet/" + version + "/" + type + "/" + suite});
        war.addPackages(true, new String[]{"org/gatein/pc/test/portlet/framework"});
        String properties = version + "/" + type + "/" + suite + "/suite.properties";
        if (Thread.currentThread().getContextClassLoader().getResource(properties) != null) {
            war.addAsWebInfResource(properties, "suite.properties");
        }
        war.addAsWebInfResource("META-INF/portlet.tld", "tld/portlet.tld");
        war.addAsWebInfResource("META-INF/portlet_2_0.tld", "tld/portlet_2_0.tld");
        URL url = Thread.currentThread().getContextClassLoader().getResource(version + "/" + type + "/" + suite + "-war/");
        Assert.assertNotNull((Object)url);
        AbstractWarTestCase.addResources(url, war);
        return war;
    }

    private static void addResources(URL root, WebArchive target) throws Exception {
        if (root.getProtocol().equals("file")) {
            AbstractWarTestCase.addResources(new File(root.toURI()), target, new LinkedList<String>());
        } else if (root.getProtocol().equals("jar")) {
            String path = root.getFile();
            String prefix = path.substring(path.indexOf("!/") + 2);
            JarURLConnection conn = (JarURLConnection)root.openConnection();
            JarFile jarFile = conn.getJarFile();
            for (JarEntry entry : Collections.list(conn.getJarFile().entries())) {
                if (entry.isDirectory() || !entry.getName().startsWith(prefix)) continue;
                String key = entry.getName().substring(prefix.length());
                target.addAsWebResource((Asset)new ByteArrayAsset(jarFile.getInputStream(entry)), key);
            }
        }
    }

    private static void addResources(File root, WebArchive target, LinkedList<String> path) throws Exception {
        File[] list = root.listFiles();
        if (list != null) {
            for (File child : list) {
                if (child.isDirectory()) {
                    path.addLast(child.getName());
                    AbstractWarTestCase.addResources(child, target, path);
                    path.removeLast();
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                for (String dir : path) {
                    sb.append(dir).append('/');
                }
                sb.append(child.getName());
                target.addAsWebResource(child, sb.toString());
            }
        }
    }

    protected AbstractWarTestCase(String version, String type, String suite, String name, String ... deployments) {
        this.version = version;
        this.type = type;
        this.suite = suite;
        this.name = name;
        this.deployments = deployments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void test() {
        System.out.println("testing " + this.version + "/" + this.type + "/" + this.suite + "/" + this.name + " with url " + String.valueOf(this.deploymentURL));
        for (String deployment : this.deployments) {
            this.deployer.deploy(deployment);
        }
        try {
            new Conversation(this.deploymentURL, this.name).performInteractions();
        }
        finally {
            for (String deployment : this.deployments) {
                this.deployer.undeploy(deployment);
            }
        }
    }
}

