/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.unit;

import java.util.Arrays;

public final class Assert {
    public static <T> T assertInstanceOf(Object o, Class<T> c) {
        if (o == null) {
            throw Assert.createAssertionError(null, "Cannot test null object");
        }
        if (c == null) {
            throw Assert.createAssertionError(null, "Cannot test null class");
        }
        if (c.isInstance(o)) {
            return c.cast(o);
        }
        throw Assert.createAssertionError(null, "Object " + String.valueOf(o) + " with class " + o.getClass().getName() + " is not an instance of " + c.getName());
    }

    public static <T> T assertNotNull(T actual) {
        return Assert.assertNotNull(null, actual);
    }

    public static <T> T assertNotNull(String msg, T actual) {
        if (actual == null) {
            if (msg != null) {
                msg = "Expected a non null object";
            }
            Assert.fail(msg);
        }
        return actual;
    }

    public static void assertNull(Object actual) {
        Assert.assertSame(null, actual);
    }

    public static void assertNull(String msg, Object actual) {
        Assert.assertSame(msg, null, actual);
    }

    public static void assertNotSame(String msg, Object expected, Object actual) {
        if (actual == null) {
            if (msg != null) {
                msg = "Expected a non null object";
            }
            if (expected == null) {
                Assert.fail((String)msg);
            }
        } else {
            if (msg == null) {
                msg = expected != null ? "Expected " + Assert.format(actual) + " object to have a different reference than " + Assert.format(expected) : "Expected " + Assert.format(actual) + " object to be not null";
            }
            if (actual == expected) {
                Assert.fail((String)msg);
            }
        }
    }

    public static void assertNotSame(Object expected, Object actual) {
        Assert.assertNotSame(null, expected, actual);
    }

    public static void assertSame(String msg, Object expected, Object actual) {
        if (actual == null) {
            if (msg == null) {
                msg = "Expected a null value";
            }
            if (expected != null) {
                Assert.fail((String)msg);
            }
        } else {
            if (msg == null) {
                msg = expected != null ? "Expected " + Assert.format(actual) + " valobjectue to have the same reference than " + Assert.format(expected) : "Expected " + Assert.format(actual) + " object to be null";
            }
            if (actual != expected) {
                Assert.fail((String)msg);
            }
        }
    }

    public static void assertSame(Object expected, Object actual) {
        Assert.assertSame(null, expected, actual);
    }

    public static void assertNotEquals(String msg, Object expected, Object actual) {
        if (actual == null) {
            if (msg != null) {
                msg = "Expected a non null object";
            }
            if (expected == null) {
                Assert.fail((String)msg);
            }
        } else {
            if (msg == null) {
                msg = "Expected " + Assert.format(actual) + " object to be not equals to " + Assert.format(expected);
            }
            if (actual.equals(expected)) {
                Assert.fail((String)msg);
            }
        }
    }

    public static void assertNotEquals(Object expected, Object actual) {
        Assert.assertNotEquals(null, expected, actual);
    }

    public static void assertEquals(String msg, Object expected, Object actual) {
        if (actual == null) {
            if (expected != null) {
                if (msg == null) {
                    msg = "Expected " + Assert.format(expected) + " instead of null";
                }
                Assert.fail((String)msg);
            }
        } else {
            if (msg == null) {
                msg = "Expected " + Assert.format(actual) + " object to be equals to " + Assert.format(expected);
            }
            if (!actual.equals(expected)) {
                Assert.fail((String)msg);
            }
        }
    }

    public static void assertEquals(Object expected, Object actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertTrue(boolean b) {
        Assert.assertTrue(null, b);
    }

    public static void assertTrue(String msg, boolean b) {
        Assert.assertEquals(msg, true, b);
    }

    public static void assertFalse(boolean b) {
        Assert.assertFalse(null, b);
    }

    public static void assertFalse(String msg, boolean b) {
        Assert.assertEquals(msg, false, b);
    }

    public static void fail(Throwable cause) {
        throw Assert.createAssertionError(cause, null);
    }

    public static void fail() {
        throw Assert.createAssertionError(null, null);
    }

    public static void fail(String msg) {
        throw Assert.createAssertionError(null, msg);
    }

    public static void fail(Throwable cause, String msg) {
        throw Assert.createAssertionError(cause, msg);
    }

    public static Error createFailure() {
        return Assert.createFailure((String)null);
    }

    public static Error createFailure(String msg) {
        return Assert.createAssertionError(null, msg);
    }

    public static Error createFailure(Throwable throwable) {
        return Assert.createAssertionError(throwable, null);
    }

    public static Error createAssertionError(Throwable cause, String msg) {
        if (msg == null) {
            msg = "Failure";
        }
        AssertionError assertionError = new AssertionError((Object)msg);
        if (cause != null) {
            ((Throwable)((Object)assertionError)).initCause(cause);
        }
        return assertionError;
    }

    public static void assertEquals(Object[] expected, Object[] actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, Object[] expected, Object[] actual) {
        if (!Arrays.equals(expected, actual)) {
            Assert.fail(Assert.format(message, expected, actual));
        }
    }

    public static void assertEquals(char[] expected, char[] actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, char[] expected, char[] actual) {
        if (!Arrays.equals(expected, actual)) {
            Assert.fail(Assert.format(message, expected, expected));
        }
    }

    public static void assertEquals(byte[] expected, byte[] actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, byte[] expected, byte[] actual) {
        if (!Arrays.equals(expected, actual)) {
            Assert.fail(Assert.format(message, expected, expected));
        }
    }

    public static void assertEquals(int[] expected, int[] actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, int[] expected, int[] actual) {
        if (!Arrays.equals(expected, actual)) {
            Assert.fail(Assert.format(message, expected, expected));
        }
    }

    public static void assertEquals(float[] expected, float[] actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, float[] expected, float[] actual) {
        if (!Arrays.equals(expected, actual)) {
            Assert.fail(Assert.format(message, expected, expected));
        }
    }

    public static void assertEquals(short[] expected, short[] actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, short[] expected, short[] actual) {
        if (!Arrays.equals(expected, actual)) {
            Assert.fail(Assert.format(message, expected, expected));
        }
    }

    public static void assertEquals(long[] expected, long[] actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, long[] expected, long[] actual) {
        if (!Arrays.equals(expected, actual)) {
            Assert.fail(Assert.format(message, expected, expected));
        }
    }

    public static void assertEquals(double[] expected, double[] actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, double[] expected, double[] actual) {
        if (!Arrays.equals(expected, actual)) {
            Assert.fail(Assert.format(message, expected, expected));
        }
    }

    public static void assertEquals(boolean[] expected, boolean[] actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, boolean[] expected, boolean[] actual) {
        if (!Arrays.equals(expected, actual)) {
            Assert.fail(Assert.format(message, expected, expected));
        }
    }

    private static String format(String message, Object expected, Object actual) {
        Object formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        return (String)formatted + "expected:" + Assert.format(expected) + " but was:" + Assert.format(actual);
    }

    private static String format(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Object[]) {
            Object[] array = (Object[])o;
            StringBuffer buffer = new StringBuffer("<[");
            for (int i = 0; i < array.length; ++i) {
                buffer.append(i == 0 ? "" : ",").append(String.valueOf(array[i]));
            }
            buffer.append("]>");
            return buffer.toString();
        }
        return " <" + String.valueOf(o) + ">";
    }
}

