/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr286.tck.dispatcher;

import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import org.gatein.pc.api.LifeCyclePhase;
import org.gatein.pc.test.portlet.jsr286.tck.dispatcher.DispatchedContainerAttributes;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.annotations.TestCase;

@TestCase(value={Assertion.JSR286_239})
public class RFRFContainerAttributes
extends DispatchedContainerAttributes {
    private static Map<String, String> buildAttributes(ServletContext ctx) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jakarta.servlet.include.request_uri", null);
        map.put("jakarta.servlet.include.context_path", null);
        map.put("jakarta.servlet.include.servlet_path", null);
        map.put("jakarta.servlet.include.path_info", null);
        map.put("jakarta.servlet.include.query_string", null);
        map.put("jakarta.servlet.forward.request_uri", ctx.getContextPath() + "/requestForwardHopServlet/pathinfo1");
        map.put("jakarta.servlet.forward.context_path", ctx.getContextPath());
        map.put("jakarta.servlet.forward.servlet_path", "/requestForwardHopServlet");
        map.put("jakarta.servlet.forward.path_info", "/pathinfo1");
        map.put("jakarta.servlet.forward.query_string", "foo1=bar1");
        return Collections.unmodifiableMap(map);
    }

    private static Map<String, String> buildInfos(ServletContext ctx) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("request_uri", ctx.getContextPath() + "/requestForwardHopServlet/pathinfo1");
        map.put("context_path", ctx.getContextPath());
        map.put("servlet_path", "/requestForwardHopServlet");
        map.put("path_info", "/pathinfo1");
        map.put("query_string", "foo1=bar1");
        return Collections.unmodifiableMap(map);
    }

    public RFRFContainerAttributes(PortletTestCase seq) {
        super(seq, RFRFContainerAttributes.buildAttributes(seq.getContext()), RFRFContainerAttributes.buildInfos(seq.getContext()));
    }

    @Override
    protected boolean performTest(LifeCyclePhase phase) {
        return phase != LifeCyclePhase.ACTION && phase != LifeCyclePhase.EVENT;
    }

    @Override
    protected void dispatch(PortletRequest request, PortletResponse response, PortletContext portletContext) throws IOException, PortletException {
        PortletRequestDispatcher dispatcher = portletContext.getRequestDispatcher("/requestForwardHopServlet/pathinfo1?foo1=bar1");
        dispatcher.forward(request, response);
    }
}

