/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.controller;

import junit.framework.TestCase;
import org.gatein.common.io.IOTools;
import org.gatein.common.io.Serialization;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.ParametersStateString;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.controller.impl.state.StateControllerContextImpl;
import org.gatein.pc.controller.state.PageNavigationalState;
import org.gatein.pc.controller.state.StateControllerContext;
import org.gatein.pc.controller.state.WindowNavigationalState;
import org.gatein.pc.test.controller.unit.PageNavigationalStateSerialization;

public class StateControllerContextTestCase
extends TestCase {
    private StateControllerContextImpl cc = new StateControllerContextImpl();

    public void testMarshalling1() {
        PageNavigationalState pageNS = new PageNavigationalState(true);
        this.assertMarshallable(pageNS);
    }

    public void testMarshalling2() {
        ParametersStateString params = ParametersStateString.create();
        params.setValue("foo", "bar");
        this.test(null, null, null);
        this.test(null, Mode.VIEW, null);
        this.test(null, null, WindowState.NORMAL);
        this.test(null, Mode.VIEW, WindowState.NORMAL);
        this.test(null, Mode.create((String)"foo"), null);
        this.test(null, null, WindowState.create((String)"bar"));
        this.test(null, Mode.create((String)"foo"), WindowState.create((String)"bar"));
        this.test((StateString)params, null, null);
        this.test((StateString)params, Mode.VIEW, null);
        this.test((StateString)params, null, WindowState.NORMAL);
        this.test((StateString)params, Mode.VIEW, WindowState.NORMAL);
        this.test((StateString)params, Mode.create((String)"foo"), null);
        this.test((StateString)params, null, WindowState.create((String)"bar"));
        this.test((StateString)params, Mode.create((String)"foo"), WindowState.create((String)"bar"));
    }

    private void test(StateString portletNavigationalState, Mode mode, WindowState windowState) {
        PageNavigationalState pageNS = new PageNavigationalState(true);
        pageNS.setWindowNavigationalState("foo", new WindowNavigationalState(portletNavigationalState, mode, windowState));
        this.assertMarshallable(pageNS);
    }

    private void assertMarshallable(PageNavigationalState pageNS) {
        byte[] bytes = IOTools.serialize((Serialization)new PageNavigationalStateSerialization((StateControllerContext)this.cc), (Object)pageNS);
        PageNavigationalState expectedPageNS = (PageNavigationalState)IOTools.unserialize((Serialization)new PageNavigationalStateSerialization((StateControllerContext)this.cc), (byte[])bytes);
        StateControllerContextTestCase.assertEquals((Object)expectedPageNS.getWindowIds(), (Object)pageNS.getWindowIds());
        for (String windowId : expectedPageNS.getWindowIds()) {
            WindowNavigationalState windowNS = expectedPageNS.getWindowNavigationalState(windowId);
            WindowNavigationalState expectedWindowNS = pageNS.getWindowNavigationalState(windowId);
            StateControllerContextTestCase.assertEquals((Object)windowNS.getPortletNavigationalState(), (Object)expectedWindowNS.getPortletNavigationalState());
            StateControllerContextTestCase.assertEquals((Object)windowNS.getMode(), (Object)expectedWindowNS.getMode());
            StateControllerContextTestCase.assertEquals((Object)windowNS.getWindowState(), (Object)expectedWindowNS.getWindowState());
        }
    }
}

