/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.gatein.pc.test.portlet.jsr286.tck.event;

import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.actions.PortletActionTestAction;
import org.gatein.pc.test.unit.actions.PortletEventTestAction;
import org.gatein.pc.test.unit.web.UTP9;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import static org.gatein.pc.test.unit.Assert.*;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;

import javax.portlet.RenderRequest;
import javax.portlet.Portlet;
import javax.portlet.RenderResponse;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import java.io.IOException;

@TestCase({Assertion.JSR286_146})
public class ExceptionDiscardChangesDuringEventPhase
{
   public ExceptionDiscardChangesDuringEventPhase(PortletTestCase seq)
   {
      seq.bindAction(0, UTP9.RENDER_JOIN_POINT, new PortletRenderTestAction()
      {
         protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context)
         {
            return new InvokeGetResponse(response.createActionURL().toString());
         }
      });
      seq.bindAction(1, UTP9.ACTION_JOIN_POINT, new PortletActionTestAction()
      {
         protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) throws PortletException, IOException
         {
            response.setEvent("Bar", null);
            response.setRenderParameter("foo", "actionbar");
         }
      });
      seq.bindAction(1, UTP9.EVENT_JOIN_POINT, new PortletEventTestAction()
      {
         protected void run(Portlet portlet, EventRequest request, EventResponse response, PortletTestContext context) throws PortletException, IOException
         {
            if (request.getEvent().getName().equals("Bar"))
            {
               response.setRenderParameter("foo", "eventbar");
               response.setEvent("Bar", null);
               throw new PortletException();
            }
            else
            {
               fail("Should not be here");
            }
         }
      });
      seq.bindAction(1, UTP9.RENDER_JOIN_POINT, new PortletRenderTestAction()
      {
         protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context)
         {
            assertEquals(1, request.getParameterMap().size());
            assertTrue(request.getParameterMap().containsKey("foo"));
            assertEquals(new String[]{"actionbar"}, request.getParameterMap().get("foo"));
            return new InvokeGetResponse(response.createActionURL().toString());
         }
      });
      seq.bindAction(2, UTP9.ACTION_JOIN_POINT, new PortletActionTestAction()
      {
         protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) throws PortletException, IOException
         {
            response.setEvent("Bar", null);
            response.setRenderParameter("foo", "actionbar");
         }
      });
      seq.bindAction(2, UTP9.EVENT_JOIN_POINT, new PortletEventTestAction()
      {
         protected void runWithRuntimeException(Portlet portlet, EventRequest request, EventResponse response, PortletTestContext context) throws PortletException, IOException
         {
            if (request.getEvent().getName().equals("Bar"))
            {
               response.setRenderParameter("foo", "eventbar");
               response.setEvent("Bar", null);
               throw new RuntimeException();
            }
            else
            {
               fail("Should not be here");
            }
         }
      });
      seq.bindAction(2, UTP9.RENDER_JOIN_POINT, new PortletRenderTestAction()
      {
         protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context)
         {
            assertEquals(1, request.getParameterMap().size());
            assertTrue(request.getParameterMap().containsKey("foo"));
            assertEquals(new String[]{"actionbar"}, request.getParameterMap().get("foo"));
            return new EndTestResponse();
         }
      });
   }
}