/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr286.tck.dispatcher;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletActionTestAction;
import org.gatein.pc.test.unit.actions.PortletEventTestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.actions.PortletResourceTestAction;
import org.gatein.pc.test.unit.actions.ServletServiceTestAction;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.AbstractUniversalTestPortlet;
import org.gatein.pc.test.unit.web.UTP1;
import org.gatein.pc.test.unit.web.UTS1;

@TestCase(value={Assertion.JSR168_142, Assertion.JSR168_143})
public class ErrorHandling {
    private ServletServiceTestAction throwRuntimeException = new ServletServiceTestAction(this){

        public Response execute(Servlet servlet, HttpServletRequest request, HttpServletResponse response, PortletTestContext context) throws ServletException, IOException {
            throw new RuntimeException();
        }
    };
    private static final ServletServiceTestAction throwIOException = new ServletServiceTestAction(){

        public Response execute(Servlet servlet, HttpServletRequest request, HttpServletResponse response, PortletTestContext context) throws ServletException, IOException {
            throw new IOException();
        }
    };
    private static final ServletServiceTestAction throwServletException = new ServletServiceTestAction(){

        public Response execute(Servlet servlet, HttpServletRequest request, HttpServletResponse response, PortletTestContext context) throws ServletException, IOException {
            throw new ServletException();
        }
    };

    public ErrorHandling(PortletTestCase seq) {
        seq.bindAction(0, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                return new InvokeGetResponse(response.createActionURL().toString());
            }
        });
        seq.bindAction(1, UTP1.ACTION_JOIN_POINT, (TestAction)new PortletActionTestAction(){

            protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) throws PortletException, IOException {
                ErrorHandling.this.dispatchAndCatchRuntimeException(portlet, (PortletRequest)request, (PortletResponse)response);
                response.setEvent("Event", null);
            }
        });
        seq.bindAction(1, UTP1.EVENT_JOIN_POINT, (TestAction)new PortletEventTestAction(){

            protected void run(Portlet portlet, EventRequest request, EventResponse response, PortletTestContext context) throws PortletException, IOException {
                ErrorHandling.this.dispatchAndCatchRuntimeException(portlet, (PortletRequest)request, (PortletResponse)response);
            }
        });
        seq.bindAction(1, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException, PortletException {
                ErrorHandling.this.dispatchAndCatchRuntimeException(portlet, (PortletRequest)request, (PortletResponse)response);
                return new InvokeGetResponse(response.createResourceURL().toString());
            }
        });
        seq.bindAction(1, UTS1.SERVICE_JOIN_POINT, (TestAction)this.throwRuntimeException);
        seq.bindAction(2, UTP1.RESOURCE_JOIN_POINT, (TestAction)new PortletResourceTestAction(){

            protected Response run(Portlet portlet, ResourceRequest request, ResourceResponse response, PortletTestContext context) throws PortletException, IOException {
                ErrorHandling.this.dispatchAndCatchRuntimeException(portlet, (PortletRequest)request, (PortletResponse)response);
                return new InvokeGetResponse(response.createActionURL().toString());
            }
        });
        seq.bindAction(2, UTS1.SERVICE_JOIN_POINT, (TestAction)this.throwRuntimeException);
        seq.bindAction(3, UTP1.ACTION_JOIN_POINT, (TestAction)new PortletActionTestAction(){

            protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) throws PortletException, IOException {
                ErrorHandling.this.dispatchAndCatchIOException(portlet, (PortletRequest)request, (PortletResponse)response);
                response.setEvent("Event", null);
            }
        });
        seq.bindAction(3, UTP1.EVENT_JOIN_POINT, (TestAction)new PortletEventTestAction(){

            protected void run(Portlet portlet, EventRequest request, EventResponse response, PortletTestContext context) throws PortletException, IOException {
                ErrorHandling.this.dispatchAndCatchIOException(portlet, (PortletRequest)request, (PortletResponse)response);
            }
        });
        seq.bindAction(3, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException {
                ErrorHandling.this.dispatchAndCatchIOException(portlet, (PortletRequest)request, (PortletResponse)response);
                return new InvokeGetResponse(response.createResourceURL().toString());
            }
        });
        seq.bindAction(3, UTS1.SERVICE_JOIN_POINT, (TestAction)throwIOException);
        seq.bindAction(4, UTP1.RESOURCE_JOIN_POINT, (TestAction)new PortletResourceTestAction(){

            protected Response run(Portlet portlet, ResourceRequest request, ResourceResponse response, PortletTestContext context) throws PortletException, IOException {
                ErrorHandling.this.dispatchAndCatchIOException(portlet, (PortletRequest)request, (PortletResponse)response);
                return new InvokeGetResponse(response.createActionURL().toString());
            }
        });
        seq.bindAction(4, UTS1.SERVICE_JOIN_POINT, (TestAction)throwIOException);
        seq.bindAction(5, UTP1.ACTION_JOIN_POINT, (TestAction)new PortletActionTestAction(){

            protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) throws PortletException, IOException {
                ErrorHandling.this.dispatchAndCatchServletException(portlet, (PortletRequest)request, (PortletResponse)response);
                response.setEvent("Event", null);
            }
        });
        seq.bindAction(5, UTP1.EVENT_JOIN_POINT, (TestAction)new PortletEventTestAction(){

            protected void run(Portlet portlet, EventRequest request, EventResponse response, PortletTestContext context) throws PortletException, IOException {
                ErrorHandling.this.dispatchAndCatchServletException(portlet, (PortletRequest)request, (PortletResponse)response);
            }
        });
        seq.bindAction(5, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException {
                ErrorHandling.this.dispatchAndCatchServletException(portlet, (PortletRequest)request, (PortletResponse)response);
                return new InvokeGetResponse(response.createResourceURL().toString());
            }
        });
        seq.bindAction(5, UTS1.SERVICE_JOIN_POINT, (TestAction)throwServletException);
        seq.bindAction(6, UTP1.RESOURCE_JOIN_POINT, (TestAction)new PortletResourceTestAction(){

            protected Response run(Portlet portlet, ResourceRequest request, ResourceResponse response, PortletTestContext context) throws PortletException, IOException {
                ErrorHandling.this.dispatchAndCatchServletException(portlet, (PortletRequest)request, (PortletResponse)response);
                return new InvokeGetResponse(response.createRenderURL().toString());
            }
        });
        seq.bindAction(6, UTS1.SERVICE_JOIN_POINT, (TestAction)throwServletException);
        seq.bindAction(7, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws IOException {
                return new EndTestResponse();
            }
        });
    }

    private void dispatchAndCatchServletException(Portlet portlet, PortletRequest request, PortletResponse response) throws IOException {
        block2: {
            PortletRequestDispatcher dispatcher = ((AbstractUniversalTestPortlet)portlet).getPortletContext().getNamedDispatcher("UniversalServletA");
            Assert.assertNotNull((Object)dispatcher);
            try {
                dispatcher.include(request, response);
                Assert.fail();
            }
            catch (PortletException e) {
                if (e.getCause() instanceof ServletException) break block2;
                Assert.fail();
            }
        }
    }

    private void dispatchAndCatchRuntimeException(Portlet portlet, PortletRequest request, PortletResponse response) throws PortletException, IOException {
        PortletRequestDispatcher dispatcher = ((AbstractUniversalTestPortlet)portlet).getPortletContext().getNamedDispatcher("UniversalServletA");
        Assert.assertNotNull((Object)dispatcher);
        try {
            dispatcher.include(request, response);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void dispatchAndCatchIOException(Portlet portlet, PortletRequest request, PortletResponse response) throws PortletException, IOException {
        PortletRequestDispatcher dispatcher = ((AbstractUniversalTestPortlet)portlet).getPortletContext().getNamedDispatcher("UniversalServletA");
        Assert.assertNotNull((Object)dispatcher);
        try {
            dispatcher.include(request, response);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

