/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr286.tck.dispatcher;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.actions.PortletResourceTestAction;
import org.gatein.pc.test.unit.actions.ServletServiceTestAction;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.AbstractUniversalTestPortlet;
import org.gatein.pc.test.unit.web.UTP1;
import org.gatein.pc.test.unit.web.UTS1;

@TestCase(value={Assertion.JSR286_278, Assertion.JSR286_279, Assertion.JSR286_280, Assertion.JSR286_281, Assertion.JSR286_282, Assertion.JSR286_283, Assertion.JSR286_284, Assertion.JSR286_286, Assertion.JSR286_287, Assertion.JSR286_288})
public class ForwardFromResourceObjects {
    public ForwardFromResourceObjects(final PortletTestCase seq) {
        seq.bindAction(0, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException {
                InvokeGetResponse resource = new InvokeGetResponse(response.createResourceURL().toString());
                resource.addHeader("myheader", "render-value");
                return resource;
            }
        });
        seq.bindAction(1, UTP1.RESOURCE_JOIN_POINT, (TestAction)new PortletResourceTestAction(this){

            protected Response run(Portlet portlet, ResourceRequest request, ResourceResponse response, PortletTestContext context) throws PortletException, IOException {
                String queryString = "?key1=k1value1&key2=k2value1";
                PortletRequestDispatcher dispatcher = ((AbstractUniversalTestPortlet)portlet).getPortletContext().getRequestDispatcher("/universalServletA" + queryString);
                dispatcher.forward((PortletRequest)request, (PortletResponse)response);
                return null;
            }
        });
        seq.bindAction(1, UTS1.SERVICE_JOIN_POINT, (TestAction)new ServletServiceTestAction(this){

            protected Response run(Servlet servlet, HttpServletRequest request, HttpServletResponse response, PortletTestContext context) throws ServletException, IOException {
                ResourceRequest portletRequest = (ResourceRequest)request.getAttribute("javax.portlet.request");
                ResourceResponse portletResponse = (ResourceResponse)request.getAttribute("javax.portlet.response");
                Assert.assertNotNull((Object)portletRequest);
                Assert.assertNotNull((Object)portletResponse);
                response.setContentType("text/html");
                Assert.assertNull((Object)request.getRemoteAddr());
                Assert.assertNull((Object)request.getRemoteHost());
                Assert.assertNull((Object)request.getLocalAddr());
                Assert.assertNull((Object)request.getLocalName());
                Assert.assertNull((Object)request.getRequestURL());
                Assert.assertEquals((Object)0, (Object)request.getRemotePort());
                Assert.assertEquals((Object)0, (Object)request.getLocalPort());
                Assert.assertEquals(null, (Object)request.getPathInfo());
                Assert.assertEquals((Object)"key1=k1value1&key2=k2value1", (Object)request.getQueryString());
                Assert.assertEquals((Object)(seq.getContext().getContextPath() + "/universalServletA"), (Object)request.getRequestURI());
                Assert.assertEquals((Object)"/universalServletA", (Object)request.getServletPath());
                Assert.assertEquals((Object)portletRequest.getScheme(), (Object)request.getScheme());
                Assert.assertEquals((Object)portletRequest.getServerName(), (Object)request.getServerName());
                Assert.assertEquals((Object)portletRequest.getServerPort(), (Object)request.getServerPort());
                request.setAttribute("key1", (Object)"k1atrr1");
                request.setAttribute("key2", (Object)"k2attr2");
                LinkedList attrNames = new LinkedList();
                Enumeration attrEnum = request.getAttributeNames();
                while (attrEnum.hasMoreElements()) {
                    attrNames.add(attrEnum.nextElement());
                }
                Assert.assertNotNull((Object)request.getAttribute("key1"));
                Assert.assertNotNull((Object)request.getAttribute("key2"));
                Assert.assertTrue((boolean)attrNames.contains("key1"));
                Assert.assertTrue((boolean)attrNames.contains("key2"));
                request.removeAttribute("key1");
                Assert.assertNull((Object)request.getAttribute("key1"));
                Assert.assertNotNull((Object)request.getAttribute("key2"));
                Assert.assertEquals((Object)portletRequest.getLocale(), (Object)request.getLocale());
                LinkedList portletLocales = new LinkedList();
                LinkedList servletLocales = new LinkedList();
                Enumeration pl = portletRequest.getLocales();
                while (pl.hasMoreElements()) {
                    portletLocales.add(pl.nextElement());
                }
                Enumeration sl = request.getLocales();
                while (sl.hasMoreElements()) {
                    servletLocales.add(sl.nextElement());
                }
                Assert.assertTrue((boolean)portletLocales.equals(servletLocales));
                Assert.assertEquals((Object)portletRequest.isSecure(), (Object)request.isSecure());
                Assert.assertEquals((Object)portletRequest.getAuthType(), (Object)request.getAuthType());
                Assert.assertEquals((Object)portletRequest.getContextPath(), (Object)request.getContextPath());
                Assert.assertEquals((Object)portletRequest.getRemoteUser(), (Object)request.getRemoteUser());
                Assert.assertEquals((Object)portletRequest.getUserPrincipal(), (Object)request.getUserPrincipal());
                Assert.assertEquals((Object)portletRequest.getRequestedSessionId(), (Object)request.getRequestedSessionId());
                Assert.assertEquals((Object)portletRequest.isRequestedSessionIdValid(), (Object)request.isRequestedSessionIdValid());
                Assert.assertEquals((Object[])portletRequest.getCookies(), (Object[])request.getCookies());
                try {
                    request.setCharacterEncoding("utf8");
                    Assert.assertTrue((boolean)false);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                Assert.assertEquals((Object)portletRequest.getCharacterEncoding(), (Object)request.getCharacterEncoding());
                Assert.assertEquals((Object)portletRequest.getContentType(), (Object)request.getContentType());
                Assert.assertEquals((Object)portletRequest.getMethod(), (Object)request.getMethod());
                Assert.assertEquals((Object)portletRequest.getReader(), (Object)request.getReader());
                LinkedList paramNames = new LinkedList();
                Enumeration paramEnum = request.getParameterNames();
                while (paramEnum.hasMoreElements()) {
                    paramNames.add(paramEnum.nextElement());
                }
                Assert.assertTrue((boolean)paramNames.contains("key1"));
                Assert.assertTrue((boolean)paramNames.contains("key2"));
                Assert.assertEquals((Object)"k1value1", (Object)request.getParameter("key1"));
                Assert.assertEquals((Object[])new String[]{"k1value1"}, (Object[])request.getParameterValues("key1"));
                Map paramNamesMap = request.getParameterMap();
                Assert.assertTrue((boolean)paramNamesMap.containsKey("key1"));
                Assert.assertTrue((boolean)paramNamesMap.containsKey("key2"));
                Assert.assertEquals((Object)portletRequest.getProperty("myheader"), (Object)request.getHeader("myheader"));
                ArrayList rheaders = Collections.list(request.getHeaders("myheader"));
                ArrayList pheaders = Collections.list(portletRequest.getProperties("myheader"));
                for (Object o : pheaders) {
                    Assert.assertTrue((boolean)rheaders.contains(o));
                }
                ArrayList headerNames = Collections.list(request.getHeaderNames());
                Enumeration propertyNamesE = portletRequest.getPropertyNames();
                while (propertyNamesE.hasMoreElements()) {
                    Object o = propertyNamesE.nextElement();
                    Assert.assertTrue((boolean)headerNames.contains(o));
                }
                Assert.assertTrue((boolean)headerNames.contains("myheader"));
                Assert.assertEquals((Object)"HTTP/1.1", (Object)request.getProtocol());
                Assert.assertNull((Object)response.encodeRedirectURL("lolo"));
                Assert.assertEquals((Object)portletResponse.getCharacterEncoding(), (Object)response.getCharacterEncoding());
                Assert.assertEquals((Object)portletResponse.getBufferSize(), (Object)response.getBufferSize());
                Assert.assertEquals((Object)portletResponse.isCommitted(), (Object)response.isCommitted());
                Assert.assertNotNull((Object)response.getOutputStream());
                Assert.assertEquals((Object)portletResponse.getLocale(), (Object)response.getLocale());
                Assert.assertEquals((Object)portletResponse.encodeURL("http://www.jboss.com/"), (Object)response.encodeURL("http://www.jboss.com/"));
                return new EndTestResponse();
            }
        });
    }
}

