/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.unit;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.Header;
import org.gatein.common.NotYetImplemented;
import org.gatein.pc.test.unit.JoinPoint;
import org.gatein.pc.test.unit.JoinPointType;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.protocol.DriverContext;
import org.gatein.pc.test.unit.protocol.response.FailureResponse;
import org.gatein.pc.test.unit.protocol.response.Response;

public class PortletTestContext {
    final String testName;
    final PortletTestCase portletTestCase;
    final Set<JoinPoint> invoked;
    final DriverContext driverContext;

    public PortletTestContext(String testName, PortletTestCase portletTestCase, DriverContext driverContext) {
        if (driverContext == null) {
            throw new IllegalArgumentException("No request context to wrap");
        }
        this.testName = testName;
        this.portletTestCase = portletTestCase;
        this.driverContext = driverContext;
        this.invoked = new HashSet<JoinPoint>();
    }

    public String getTestName() {
        return this.testName;
    }

    public void setInvoked(JoinPoint joinPoint) {
        this.invoked.add(joinPoint);
    }

    public String getActorId(JoinPointType joinPointType) {
        return this.portletTestCase.getActorId(this.driverContext.getRequestCount(), joinPointType);
    }

    public Response getResponse() {
        return this.driverContext.getResponse();
    }

    public void updateResponse(Response response) {
        if (response == null) {
            throw new IllegalArgumentException();
        }
        Response existingResponse = this.driverContext.getResponse();
        if (!(existingResponse instanceof FailureResponse) && (response instanceof FailureResponse || existingResponse == null)) {
            this.driverContext.setResponse(response);
        }
    }

    public int getRequestCount() {
        return this.driverContext.getRequestCount();
    }

    public String rewriteURLForNode(String url) throws MalformedURLException {
        throw new NotYetImplemented("todo");
    }

    public Map<String, Serializable> getPayload() {
        return this.driverContext.getPayload();
    }

    public byte[] getResponseBody() {
        return (byte[])this.getPayload().get("http.response.body");
    }

    public HashMap<String, Header> getResponseHeaders() {
        return (HashMap)this.getPayload().get("http.response.headers");
    }

    private static class JoinPointInvocation {
        private final int requestCount;
        private final JoinPoint joinPoint;

        private JoinPointInvocation(int requestCount, JoinPoint joinPoint) {
            this.requestCount = requestCount;
            this.joinPoint = joinPoint;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof JoinPointInvocation) {
                JoinPointInvocation that = (JoinPointInvocation)obj;
                return this.requestCount == that.requestCount && this.joinPoint.equals(that.joinPoint);
            }
            return false;
        }

        public int hashCode() {
            return this.requestCount + this.joinPoint.hashCode();
        }
    }
}

