/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr286.ext.event;

import java.io.IOException;
import java.io.Serializable;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.gatein.pc.test.portlet.jsr286.ext.common.CommonEventPayload;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.Assertion;
import org.gatein.pc.test.unit.PortletTestCase;
import org.gatein.pc.test.unit.PortletTestContext;
import org.gatein.pc.test.unit.TestAction;
import org.gatein.pc.test.unit.actions.PortletActionTestAction;
import org.gatein.pc.test.unit.actions.PortletEventTestAction;
import org.gatein.pc.test.unit.actions.PortletRenderTestAction;
import org.gatein.pc.test.unit.annotations.Archive;
import org.gatein.pc.test.unit.annotations.TestCase;
import org.gatein.pc.test.unit.protocol.response.EndTestResponse;
import org.gatein.pc.test.unit.protocol.response.InvokeGetResponse;
import org.gatein.pc.test.unit.protocol.response.Response;
import org.gatein.pc.test.unit.web.UTP1;

@TestCase(value={Assertion.EXT_EVENT_1}, deployments={@Archive(value={"jsr286", "ext", "eventsupport"})})
public class EventPayloadBetweenApplications {
    boolean commonEventPonged = false;
    CommonEventPayload commonPayload;
    boolean sharedEventPonged = false;

    public EventPayloadBetweenApplications(PortletTestCase seq) {
        seq.bindAction(0, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(this){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException {
                return new InvokeGetResponse(response.createActionURL().toString());
            }
        });
        seq.bindAction(1, UTP1.ACTION_JOIN_POINT, (TestAction)new PortletActionTestAction(){

            protected void run(Portlet portlet, ActionRequest request, ActionResponse response, PortletTestContext context) throws PortletException, IOException {
                EventPayloadBetweenApplications.this.commonPayload = new CommonEventPayload();
                EventPayloadBetweenApplications.this.commonPayload.setString("commonpingvalue");
                response.setEvent("CommonPing", (Serializable)EventPayloadBetweenApplications.this.commonPayload);
            }
        });
        seq.bindAction(1, UTP1.EVENT_JOIN_POINT, (TestAction)new PortletEventTestAction(){

            protected void run(Portlet portlet, EventRequest request, EventResponse response, PortletTestContext context) throws PortletException, IOException {
                Assert.assertEquals((Object)"commonpingvalue", (Object)EventPayloadBetweenApplications.this.commonPayload.getString());
                Event event = request.getEvent();
                Assert.assertEquals((Object)"CommonPong", (Object)event.getName());
                CommonEventPayload payload = (CommonEventPayload)event.getValue();
                Assert.assertEquals((Object)"commonpongvalue", (Object)payload.getString());
                EventPayloadBetweenApplications.this.commonEventPonged = true;
            }
        });
        seq.bindAction(1, UTP1.RENDER_JOIN_POINT, (TestAction)new PortletRenderTestAction(){

            protected Response run(Portlet portlet, RenderRequest request, RenderResponse response, PortletTestContext context) throws PortletException, IOException {
                Assert.assertTrue((boolean)EventPayloadBetweenApplications.this.commonEventPonged);
                return new EndTestResponse();
            }
        });
    }
}

