/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet.jsr286.tck.taglib;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.gatein.pc.api.ParametersStateString;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.test.unit.Assert;
import org.gatein.pc.test.unit.PortletTestContext;

public abstract class Taglib {
    protected String startTag;
    protected String endTag;
    protected String expectedResult;
    protected String[] expectedResults;

    protected void include(PortletRequestDispatcher dispatcher, RenderRequest request, RenderResponse response) throws IOException, PortletException {
        this.startTag = "<div id=" + response.getNamespace() + ">";
        this.endTag = "</div>";
        PrintWriter writer = response.getWriter();
        ((Writer)writer).write(this.startTag);
        dispatcher.include(request, response);
        ((Writer)writer).write(this.endTag);
    }

    protected void assertResult(PortletTestContext context) {
        String prevResponse = new String(context.getResponseBody());
        String portletResp = prevResponse.substring(prevResponse.indexOf(this.startTag) + this.startTag.length(), prevResponse.indexOf(this.endTag));
        Assert.assertEquals((Object)this.expectedResult, (Object)portletResp.trim());
    }

    protected void assertResults(PortletTestContext context) {
        String prevResponse = new String(context.getResponseBody());
        String portletResp = prevResponse.substring(prevResponse.indexOf(this.startTag) + this.startTag.length(), prevResponse.indexOf(this.endTag));
        String[] results = portletResp.split("<test_result_separator/>");
        for (int i = 0; i < results.length; ++i) {
            results[i] = results[i].trim();
            int indexExpectedUrl = this.expectedResults[i].indexOf("?");
            String expectedBaseUrl = this.expectedResults[i].substring(0, indexExpectedUrl);
            int indexResultUrl = results[i].indexOf("?");
            String resultBaseUrl = results[i].substring(0, indexResultUrl);
            Assert.assertEquals((Object)expectedBaseUrl, (Object)resultBaseUrl);
            Map<String, String> expectedParams = this.extractParams(this.expectedResults[i].substring(indexExpectedUrl));
            Map<String, String> resultParams = this.extractParams(results[i].substring(indexResultUrl));
            Assert.assertEquals((Object)expectedParams.size(), (Object)resultParams.size());
            for (String key : resultParams.keySet()) {
                if (key.equals("interactionstate")) {
                    Map expectedInteractionParams = ((ParametersStateString)ParametersStateString.create((String)expectedParams.get(key))).getParameters();
                    Map resultInteractionParams = ((ParametersStateString)ParametersStateString.create((String)resultParams.get(key))).getParameters();
                    Assert.assertEquals((Object)expectedInteractionParams.size(), (Object)resultInteractionParams.size());
                    expectedInteractionParams.keySet().stream().forEach(expectedKey -> Arrays.equals((Object[])expectedInteractionParams.get(expectedKey), (Object[])resultInteractionParams.get(expectedKey)));
                    continue;
                }
                Assert.assertEquals((Object)expectedParams.get(key), (Object)resultParams.get(key));
            }
        }
    }

    private Map<String, String> extractParams(String queryParams) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        String[] params = queryParams.split("&amp;");
        if (params.length == 1) {
            params = queryParams.split("&");
        }
        for (String param : params) {
            String[] splittedParam = param.split("=");
            paramsMap.put(splittedParam[0], splittedParam[1]);
        }
        return paramsMap;
    }

    protected PortletInvocation getInvocation(PortletRequest req) {
        return (PortletInvocation)req.getAttribute("org.jboss.portal.attribute.component_invocation");
    }
}

