/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.test.deployment;

import java.util.HashSet;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.gatein.wci.ServletContainer;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.WebApp;
import org.gatein.wci.WebAppListener;
import org.gatein.wci.test.AbstractWCITestCase;
import org.gatein.wci.test.WebAppRegistry;
import org.gatein.wci.test.deployment.NativeSkipFilter;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;

public abstract class AbstractDeploymentTestCase
extends AbstractWCITestCase {
    private static WebAppRegistry registry;
    private static Set<String> keys;
    private static ServletContainer container;
    @ArquillianResource
    Deployer deployer;

    @Deployment(name="deploymentnative", managed=false)
    public static WebArchive nativeDeployment() {
        WebArchive war = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"deploymentnative.war");
        return war;
    }

    @Deployment(name="deploymentnativeskip", managed=false)
    public static WebArchive nativeSkipDeployment() {
        WebArchive war = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"deploymentnativeskip.war");
        war.setWebXML(AbstractDeploymentTestCase.getAsset("<!DOCTYPE web-app PUBLIC\n\"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\"\n\"http://java.sun.com/dtd/web-app_2_3.dtd\">\n<web-app>\n<context-param>\n<param-name>gatein.wci.native.DisableRegistration</param-name>\n<param-value>true</param-value>\n</context-param>\n<listener>\n<listener-class>org.gatein.wci.test.deployment.NativeSkipFilter</listener-class>\n</listener>\n</web-app>\n"));
        return war;
    }

    @Deployment(name="deploymentnativeskipgatein", managed=false)
    public static WebArchive nativeSkipGateInDeployment() {
        WebArchive war = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"deploymentnativeskipgatein.war");
        war.setWebXML(AbstractDeploymentTestCase.getAsset("<!DOCTYPE web-app PUBLIC\n\"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\"\n\"http://java.sun.com/dtd/web-app_2_3.dtd\">\n<web-app>\n<context-param>\n<param-name>gatein.wci.native.DisableRegistration</param-name>\n<param-value>true</param-value>\n</context-param>\n<servlet>\n<servlet-name>GateInServlet</servlet-name>\n<servlet-class>org.gatein.wci.api.GateInServlet</servlet-class>\n<load-on-startup>1</load-on-startup>\n</servlet>\n<servlet-mapping>\n<servlet-name>GateInServlet</servlet-name>\n<url-pattern>/gateinservlet</url-pattern>\n</servlet-mapping></web-app>\n"));
        return war;
    }

    @Deployment(name="deploymentgatein", managed=false)
    public static WebArchive gateInDeployment() {
        WebArchive war = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"deploymentgatein.war");
        war.setWebXML(AbstractDeploymentTestCase.getAsset("<!DOCTYPE web-app PUBLIC\n\"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\"\n\"http://java.sun.com/dtd/web-app_2_3.dtd\">\n<web-app>\n<servlet>\n<servlet-name>GateInServlet</servlet-name>\n<servlet-class>org.gatein.wci.api.GateInServlet</servlet-class>\n<load-on-startup>1</load-on-startup>\n</servlet>\n<servlet-mapping>\n<servlet-name>GateInServlet</servlet-name>\n<url-pattern>/gateinservlet</url-pattern>\n</servlet-mapping></web-app>\n"));
        return war;
    }

    @Test
    @InSequence(value=0)
    public void testBefore() {
        ServletContainer _container = ServletContainerFactory.getServletContainer();
        Assert.assertNotNull((Object)_container);
        WebAppRegistry _registry = new WebAppRegistry();
        _container.addWebAppListener((WebAppListener)_registry);
        HashSet<String> _keys = new HashSet<String>(_registry.getKeys());
        registry = _registry;
        keys = _keys;
        container = _container;
    }

    @Test
    @RunAsClient
    @InSequence(value=1)
    public void testDeployApp() {
        this.deployer.deploy("deploymentnative");
    }

    @Test
    @InSequence(value=2)
    public void testAfterDeployApp() {
        HashSet diff = new HashSet(registry.getKeys());
        diff.removeAll(keys);
        if (diff.size() != 1) {
            throw new AssertionFailedError("The size of the new web application deployed should be 1, it is " + diff.size() + " instead.The previous set was " + String.valueOf(keys) + " and the new set is " + String.valueOf(registry.getKeys()));
        }
        String key = (String)diff.iterator().next();
        if (!"/deploymentnative".equals(key)) {
            throw new AssertionFailedError("The newly deployed web application should be /deployment-war and it is " + key);
        }
        WebApp webApp = registry.getWebApp("/deploymentnative");
        if (webApp == null) {
            throw new AssertionFailedError("The web app /deploymentnative was not found");
        }
        if (!"/deploymentnative".equals(webApp.getContextPath())) {
            throw new AssertionFailedError("The web app context is not equals to the expected value but has the value " + webApp.getContextPath());
        }
    }

    @Test
    @RunAsClient
    @InSequence(value=3)
    public void testUndeployApp() {
        this.deployer.undeploy("deploymentnative");
    }

    @Test
    @InSequence(value=4)
    public void testAfterUndeployApp() {
        if (!registry.getKeys().equals(keys)) {
            throw new AssertionFailedError("The size of the new web application deployed should be equals: " + String.valueOf(keys) + " != " + String.valueOf(registry.getKeys()));
        }
    }

    @Test
    @RunAsClient
    @InSequence(value=5)
    public void testDeployNativeSkip() {
        this.deployer.deploy("deploymentnativeskip");
    }

    @Test
    @InSequence(value=6)
    public void testAfterDeployNativeSkip() {
        Assert.assertEquals(keys, (Object)registry.getKeys());
        Assert.assertTrue((String)("Was expecting " + String.valueOf(NativeSkipFilter.contextPaths) + " to contain /deploymentnativeskip"), (boolean)NativeSkipFilter.contextPaths.contains("/deploymentnativeskip"));
    }

    @Test
    @RunAsClient
    @InSequence(value=7)
    public void testUndeployNativeSkip() {
        this.deployer.undeploy("deploymentnativeskip");
    }

    @Test
    @InSequence(value=8)
    public void testAfterUndeployNativeSkip() {
        Assert.assertEquals(keys, (Object)registry.getKeys());
        Assert.assertFalse((String)("Was expecting " + String.valueOf(NativeSkipFilter.contextPaths) + " to not contain /deploymentnativeskip"), (boolean)NativeSkipFilter.contextPaths.contains("/deploymentnativeskip"));
    }

    @Test
    @RunAsClient
    @InSequence(value=9)
    public void testDeployNativeSkipGateIn() {
        this.deployer.deploy("deploymentnativeskipgatein");
    }

    @Test
    @InSequence(value=10)
    public void testAfterDeployNativeSkipGateIn() {
        HashSet<String> tmp = new HashSet<String>(keys);
        tmp.add("/deploymentnativeskipgatein");
        Assert.assertEquals(tmp, (Object)registry.getKeys());
    }

    @Test
    @RunAsClient
    @InSequence(value=11)
    public void testUndeployNativeSkipGateIn() {
        this.deployer.undeploy("deploymentnativeskipgatein");
    }

    @Test
    @InSequence(value=12)
    public void testAfterUndeployNativeSkipGateIn() {
        Assert.assertEquals(keys, (Object)registry.getKeys());
    }

    @Test
    @RunAsClient
    @InSequence(value=13)
    public void testDeployGateIn() {
        this.deployer.deploy("deploymentgatein");
    }

    @Test
    @InSequence(value=14)
    public void testAfterDeployGateIn() {
        HashSet<String> tmp = new HashSet<String>(keys);
        tmp.add("/deploymentgatein");
        Assert.assertEquals(tmp, (Object)registry.getKeys());
    }

    @Test
    @RunAsClient
    @InSequence(value=15)
    public void testUndeployGateIn() {
        this.deployer.undeploy("deploymentgatein");
    }

    @Test
    @InSequence(value=16)
    public void testAfterUndeployGateIn() {
        Assert.assertEquals(keys, (Object)registry.getKeys());
    }

    @Test
    @InSequence(value=400)
    public void testAfter() {
        if (!registry.getKeys().equals(keys)) {
            throw new AssertionFailedError("The size of the new web application deployed should be equals: " + String.valueOf(keys) + " != " + String.valueOf(registry.getKeys()));
        }
        container.removeWebAppListener((WebAppListener)registry);
        if (registry.getKeys().size() > 0) {
            throw new AssertionFailedError("The set of deployed web application should be empty instead of " + String.valueOf(registry.getKeys()));
        }
    }
}

