/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.test.tomcat.deployment;

import junit.framework.Assert;
import org.gatein.wci.ServletContainer;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.WebAppListener;
import org.gatein.wci.test.AbstractWCITestCase;
import org.gatein.wci.test.WebAppRegistry;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;

public class RedeployServiceTestCase
extends AbstractWCITestCase {
    @ArquillianResource
    Deployer deployer;

    @Test
    @RunAsClient
    @InSequence(value=0)
    public void deployWCIServiceArchive() {
        this.deployer.deploy("deploymentwci");
    }

    @Test
    @InSequence(value=1)
    @OperateOnDeployment(value="deploymentwci")
    public void testFirstDeploy() {
        ServletContainer _container = ServletContainerFactory.getServletContainer();
        Assert.assertNotNull((Object)_container);
        WebAppRegistry _registry = new WebAppRegistry();
        _container.addWebAppListener((WebAppListener)_registry);
        Assert.assertTrue((boolean)_registry.getKeys().contains("/deploymentwci"));
    }

    @Test
    @RunAsClient
    @InSequence(value=2)
    public void deployRedeployWCIServiceArchive() {
        this.deployer.undeploy("deploymentwci");
        this.deployer.deploy("deploymentwci");
    }

    @Test
    @InSequence(value=3)
    @OperateOnDeployment(value="deploymentwci")
    public void testReDeploy() {
        ServletContainer _container = ServletContainerFactory.getServletContainer();
        Assert.assertNotNull((Object)_container);
        WebAppRegistry _registry = new WebAppRegistry();
        _container.addWebAppListener((WebAppListener)_registry);
        Assert.assertTrue((boolean)_registry.getKeys().contains("/deploymentwci"));
    }

    @Test
    @RunAsClient
    @InSequence(value=4)
    public void undeployArchive() {
        this.deployer.undeploy("deploymentwci");
    }

    @Deployment(name="deploymentwci", managed=false, testable=true)
    public static WebArchive wciDeployment() {
        WebArchive war = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"deploymentwci.war");
        war.setWebXML("org/gatein/wci/test/tomcat/deployment/web.xml");
        war.addAsManifestResource("org/gatein/wci/test/tomcat/deployment/context.xml", "context.xml");
        return war;
    }
}

