/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.ide.rest;

import io.meeds.ide.model.Widget;
import io.meeds.ide.service.WidgetService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.concurrent.TimeUnit;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/widgets"})
@Tag(name="/ide/rest/widgets", description="Managing Web Application Widgets")
public class WidgetRest {
    private static final CacheControl CACHE_CONTROL = CacheControl.maxAge((long)365L, (TimeUnit)TimeUnit.DAYS).cachePublic();
    @Autowired
    private WidgetService widgetService;

    @GetMapping(value={"{id}"})
    @Operation(summary="Retrieve a Web application widget", method="GET", description="This will retrieve a page template designated by its id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Widget not found")})
    public Widget getWidget(@Parameter(description="Widget identifier") @PathVariable(value="id") long id) {
        try {
            return this.widgetService.getWidget(id);
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
    }

    @GetMapping(value={"{id}/html"})
    @Operation(summary="Retrieve a Web application widget html", method="GET", description="Retrieve a Web application widget html")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Widget not found")})
    public ResponseEntity<String> getWidgetHtml(HttpServletRequest request, @Parameter(description="Widget identifier") @PathVariable(value="id") long id) {
        try {
            Widget widget = this.widgetService.getWidget(id);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CACHE_CONTROL)).contentType(MediaType.TEXT_HTML).body((Object)widget.getHtml());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
    }

    @GetMapping(value={"{id}/css"})
    @Operation(summary="Retrieve a Web application widget css", method="GET", description="Retrieve a Web application widget css")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Widget not found")})
    public ResponseEntity<String> getWidgetCss(HttpServletRequest request, @Parameter(description="Widget identifier") @PathVariable(value="id") long id) {
        try {
            Widget widget = this.widgetService.getWidget(id);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CACHE_CONTROL)).contentType(MediaType.parseMediaType((String)"text/css")).body((Object)widget.getCss());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
    }

    @GetMapping(value={"{id}/js"})
    @Operation(summary="Retrieve a Web application widget javascript", method="GET", description="Retrieve a Web application widget javascript")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Widget not found")})
    public ResponseEntity<String> getWidgetJs(HttpServletRequest request, @Parameter(description="Widget identifier") @PathVariable(value="id") long id) {
        try {
            Widget widget = this.widgetService.getWidget(id);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CACHE_CONTROL)).contentType(MediaType.parseMediaType((String)"text/javascript")).body((Object)widget.getJs());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
    }

    @PutMapping(value={"{id}"})
    @Secured(value={"administrators"})
    @Operation(summary="Update an existing a Web application widget", method="PUT", description="Update an existing a Web application widget")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not found")})
    public void updateWidget(HttpServletRequest request, @Parameter(description="Widget identifier") @PathVariable(value="id") long id, @RequestBody Widget widget) {
        try {
            widget.setId(id);
            this.widgetService.updateWidget(widget, request.getRemoteUser());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }
}

