/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.ide.storage;

import io.meeds.ide.dao.WidgetDAO;
import io.meeds.ide.entity.WidgetEntity;
import io.meeds.ide.model.Widget;
import io.meeds.ide.storage.WidgetStorage;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Optional;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.jpa.domain.Specification;

@SpringBootTest(classes={WidgetStorage.class})
@ExtendWith(value={MockitoExtension.class})
public class WidgetStorageTest {
    private static final String HTML_CONTENT = "...html...";
    private static final String CSS_CONTENT = "...css...";
    private static final String JS_CONTENT = "...js...";
    private static final LocalDateTime CREATED_DATE = LocalDate.of(2024, 8, 21).atStartOfDay();
    private static final LocalDateTime MODIFIED_DATE = LocalDate.of(2024, 8, 22).atStartOfDay().minusHours(16L);
    @MockBean
    private WidgetDAO widgetDAO;
    @Autowired
    private WidgetStorage widgetStorage;
    @Mock
    private WidgetEntity widgetEntity;
    @Mock
    private Widget widget;

    @Test
    public void getWidget() {
        Mockito.when((Object)this.widgetDAO.findById((Object)2L)).thenReturn(Optional.of(this.widgetEntity));
        Mockito.when((Object)this.widgetEntity.getId()).thenReturn((Object)2L);
        Mockito.when((Object)this.widgetEntity.getHtml()).thenReturn((Object)HTML_CONTENT);
        Mockito.when((Object)this.widgetEntity.getCss()).thenReturn((Object)CSS_CONTENT);
        Mockito.when((Object)this.widgetEntity.getJs()).thenReturn((Object)JS_CONTENT);
        Mockito.when((Object)this.widgetEntity.getCreatorId()).thenReturn((Object)6L);
        Mockito.when((Object)this.widgetEntity.getCreatedDate()).thenReturn((Object)CREATED_DATE);
        Mockito.when((Object)this.widgetEntity.getModifierId()).thenReturn((Object)5L);
        Mockito.when((Object)this.widgetEntity.getModifiedDate()).thenReturn((Object)MODIFIED_DATE);
        Widget retrievedWidget = this.widgetStorage.getWidget(Long.valueOf(2L));
        Assertions.assertNotNull((Object)retrievedWidget);
        Assertions.assertEquals((long)2L, (Long)retrievedWidget.getId());
        Assertions.assertEquals((Object)HTML_CONTENT, (Object)retrievedWidget.getHtml());
        Assertions.assertEquals((Object)CSS_CONTENT, (Object)retrievedWidget.getCss());
        Assertions.assertEquals((Object)JS_CONTENT, (Object)retrievedWidget.getJs());
        Assertions.assertEquals((long)6L, (Long)retrievedWidget.getCreatorId());
        Assertions.assertEquals((Object)CREATED_DATE, (Object)retrievedWidget.getCreatedDate());
        Assertions.assertEquals((long)5L, (Long)retrievedWidget.getModifierId());
        Assertions.assertEquals((Object)MODIFIED_DATE, (Object)retrievedWidget.getModifiedDate());
    }

    @Test
    public void existsByPortletInstanceId() {
        Mockito.when((Object)this.widgetDAO.existsByPortletId(Long.valueOf(2L))).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.widgetStorage.existsByPortletInstanceId(Long.valueOf(2L)));
        Assertions.assertFalse((boolean)this.widgetStorage.existsByPortletInstanceId(Long.valueOf(3L)));
    }

    @Test
    public void createWidget() {
        Mockito.when((Object)this.widget.getHtml()).thenReturn((Object)HTML_CONTENT);
        Mockito.when((Object)this.widget.getCss()).thenReturn((Object)CSS_CONTENT);
        Mockito.when((Object)this.widget.getJs()).thenReturn((Object)JS_CONTENT);
        Mockito.when((Object)this.widget.getCreatorId()).thenReturn((Object)6L);
        Mockito.when((Object)this.widget.getCreatedDate()).thenReturn((Object)CREATED_DATE);
        Mockito.when((Object)this.widget.getModifierId()).thenReturn((Object)5L);
        Mockito.when((Object)this.widget.getModifiedDate()).thenReturn((Object)MODIFIED_DATE);
        Mockito.when((Object)((WidgetEntity)this.widgetDAO.save((Object)((WidgetEntity)ArgumentMatchers.any(WidgetEntity.class))))).thenAnswer(invocation -> invocation.getArgument(0));
        Widget updatedWidget = this.widgetStorage.createWidget(this.widget);
        Assertions.assertNotNull((Object)updatedWidget);
        Assertions.assertEquals((Object)HTML_CONTENT, (Object)updatedWidget.getHtml());
        Assertions.assertEquals((Object)CSS_CONTENT, (Object)updatedWidget.getCss());
        Assertions.assertEquals((Object)JS_CONTENT, (Object)updatedWidget.getJs());
        Assertions.assertEquals((long)6L, (Long)updatedWidget.getCreatorId());
        Assertions.assertEquals((Object)CREATED_DATE, (Object)updatedWidget.getCreatedDate());
        Assertions.assertEquals((long)5L, (Long)updatedWidget.getModifierId());
        Assertions.assertEquals((Object)MODIFIED_DATE, (Object)updatedWidget.getModifiedDate());
    }

    @Test
    public void updateWidget() {
        Mockito.when((Object)this.widget.getHtml()).thenReturn((Object)HTML_CONTENT);
        Mockito.when((Object)this.widget.getCss()).thenReturn((Object)CSS_CONTENT);
        Mockito.when((Object)this.widget.getJs()).thenReturn((Object)JS_CONTENT);
        Mockito.when((Object)this.widget.getCreatorId()).thenReturn((Object)6L);
        Mockito.when((Object)this.widget.getCreatedDate()).thenReturn((Object)CREATED_DATE);
        Mockito.when((Object)this.widget.getModifierId()).thenReturn((Object)5L);
        Mockito.when((Object)this.widget.getModifiedDate()).thenReturn((Object)MODIFIED_DATE);
        Mockito.when((Object)((WidgetEntity)this.widgetDAO.save((Object)((WidgetEntity)ArgumentMatchers.any(WidgetEntity.class))))).thenAnswer(invocation -> invocation.getArgument(0));
        Widget updatedWidget = this.widgetStorage.updateWidget(this.widget);
        Assertions.assertNotNull((Object)updatedWidget);
        Assertions.assertEquals((Object)HTML_CONTENT, (Object)updatedWidget.getHtml());
        Assertions.assertEquals((Object)CSS_CONTENT, (Object)updatedWidget.getCss());
        Assertions.assertEquals((Object)JS_CONTENT, (Object)updatedWidget.getJs());
        Assertions.assertEquals((long)6L, (Long)updatedWidget.getCreatorId());
        Assertions.assertEquals((Object)CREATED_DATE, (Object)updatedWidget.getCreatedDate());
        Assertions.assertEquals((long)5L, (Long)updatedWidget.getModifierId());
        Assertions.assertEquals((Object)MODIFIED_DATE, (Object)updatedWidget.getModifiedDate());
    }

    @Test
    void deletePageTemplate() throws ObjectNotFoundException {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.widgetStorage.deleteWidgetById(7L));
        Mockito.when((Object)this.widgetDAO.existsById((Object)7L)).thenReturn((Object)true);
        this.widgetStorage.deleteWidgetById(7L);
        ((WidgetDAO)Mockito.verify((Object)this.widgetDAO, (VerificationMode)Mockito.times((int)1))).deleteById((Object)7L);
    }

    @Test
    void getWidgetByPortletId() {
        this.widgetStorage.getWidgetByPortletId(1L);
        ((WidgetDAO)Mockito.verify((Object)this.widgetDAO, (VerificationMode)Mockito.times((int)1))).findByPortletId(1L);
    }

    @Test
    void getWidgetsByProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key1", "value1");
        this.widgetStorage.getWidgetsByProperties(properties);
        ArgumentCaptor specCaptor = ArgumentCaptor.forClass(Specification.class);
        ((WidgetDAO)Mockito.verify((Object)this.widgetDAO, (VerificationMode)Mockito.times((int)1))).findAll((Specification)specCaptor.capture());
        Specification capturedSpec = (Specification)specCaptor.getValue();
        Assertions.assertNotNull((Object)capturedSpec, (String)"The specification should not be null");
    }
}

