/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.ide.service;

import io.meeds.ide.model.Widget;
import io.meeds.ide.service.StaticResourceService;
import io.meeds.ide.storage.WidgetStorage;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.portal.navigation.service.NavigationConfigurationService;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={StaticResourceService.class})
@ExtendWith(value={MockitoExtension.class})
class StaticResourceServiceTest {
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS_UTIL = Mockito.mockStatic(CommonsUtils.class);
    private static final String USERNAME = "testUser";
    private static final String SITE_NAME = "siteName";
    @MockBean
    private LayoutAclService layoutAclService;
    @MockBean
    private IdentityManager identityManager;
    @MockBean
    private ListenerService listenerService;
    @MockBean
    private WidgetStorage widgetStorage;
    @MockBean
    private UserPortalConfigService userPortalConfigService;
    @Autowired
    private StaticResourceService staticResourceService;
    @Mock
    private Widget widget;
    @Mock
    private Identity identity;

    StaticResourceServiceTest() {
    }

    @Test
    void getStaticResources() throws IllegalAccessException {
        Assertions.assertThrows(IllegalAccessException.class, () -> this.staticResourceService.getStaticResources(SITE_NAME, USERNAME));
        Mockito.when((Object)this.layoutAclService.isAdministrator(USERNAME)).thenReturn((Object)true);
        LinkedHashMap<String, String> filters = new LinkedHashMap<String, String>();
        filters.put(SITE_NAME, SITE_NAME);
        this.staticResourceService.getStaticResources(SITE_NAME, USERNAME);
        ((WidgetStorage)Mockito.verify((Object)this.widgetStorage)).getWidgetsByProperties(filters);
    }

    @Test
    void createStaticResource() throws IllegalAccessException {
        Assertions.assertThrows(IllegalAccessException.class, () -> this.staticResourceService.createStaticResource(this.widget, USERNAME));
        Mockito.when((Object)this.layoutAclService.isAdministrator(USERNAME)).thenReturn((Object)true);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(USERNAME)).thenReturn((Object)this.identity);
        Mockito.when((Object)this.identity.getId()).thenReturn((Object)"5");
        Mockito.when((Object)this.widgetStorage.createWidget(this.widget)).thenReturn((Object)this.widget);
        Widget savedWidget = this.staticResourceService.createStaticResource(this.widget, USERNAME);
        Assertions.assertNotNull((Object)savedWidget);
        ((Widget)Mockito.verify((Object)this.widget)).setCreatorId(Long.valueOf(5L));
        ((Widget)Mockito.verify((Object)this.widget)).setModifierId(Long.valueOf(5L));
        ((Widget)Mockito.verify((Object)this.widget)).setCreatedDate((LocalDateTime)ArgumentMatchers.notNull());
        ((Widget)Mockito.verify((Object)this.widget)).setModifiedDate((LocalDateTime)ArgumentMatchers.notNull());
        ((WidgetStorage)Mockito.verify((Object)this.widgetStorage)).createWidget(this.widget);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast("ide.widget.created", null, (Object)this.widget);
    }

    @Test
    void getStaticResourceApplications() {
        LinkedHashMap<String, String> filters = new LinkedHashMap<String, String>();
        filters.put(SITE_NAME, SITE_NAME);
        filters.put("position", "END_OF_BODY");
        filters.put("enabled", "true");
        NavigationConfigurationService navigationConfigurationService = (NavigationConfigurationService)Mockito.mock(NavigationConfigurationService.class);
        Mockito.when((Object)navigationConfigurationService.isMetaSiteNavigation(SITE_NAME)).thenReturn((Object)true);
        COMMONS_UTILS_UTIL.when(() -> CommonsUtils.getService(NavigationConfigurationService.class)).thenReturn((Object)navigationConfigurationService);
        Mockito.when((Object)this.widgetStorage.getWidgetsByProperties(filters)).thenReturn(List.of(this.widget));
        List apps = this.staticResourceService.getStaticResourceApplications(SITE_NAME, "END_OF_BODY");
        Assertions.assertEquals((int)1, (int)apps.size());
        Assertions.assertEquals((Object)"ide/WidgetPortlet", (Object)((TransientApplicationState)((Application)apps.getFirst()).getState()).getContentId());
    }
}

