/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.ide.storage;

import io.meeds.ide.dao.WidgetDAO;
import io.meeds.ide.dao.query.WidgetQueryBuilder;
import io.meeds.ide.entity.WidgetEntity;
import io.meeds.ide.model.Widget;
import io.meeds.ide.utils.Utils;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class WidgetStorage {
    private static final String CACHE_NAME = "ide.widget";
    @Autowired
    private WidgetDAO widgetDAO;

    @Cacheable(value={"ide.widget"})
    public Widget getWidget(Long id) {
        return this.widgetDAO.findById(id).map(Utils::fromEntity).orElse(null);
    }

    @CacheEvict(value={"ide.widget"}, allEntries=true)
    public Widget createWidget(Widget widget) {
        widget.setId(null);
        WidgetEntity widgetEntity = Utils.toEntity(widget);
        widgetEntity = (WidgetEntity)this.widgetDAO.save(widgetEntity);
        return Utils.fromEntity(widgetEntity);
    }

    @CacheEvict(value={"ide.widget"}, allEntries=true)
    public Widget updateWidget(Widget widget) {
        WidgetEntity widgetEntity = Utils.toEntity(widget);
        widgetEntity = (WidgetEntity)this.widgetDAO.save(widgetEntity);
        return Utils.fromEntity(widgetEntity);
    }

    @CacheEvict(value={"ide.widget"}, allEntries=true)
    public void deleteWidgetById(long widgetId) throws ObjectNotFoundException {
        if (!this.widgetDAO.existsById(widgetId)) {
            throw new ObjectNotFoundException(String.format("Widget with id %s doesn't exist", widgetId));
        }
        this.widgetDAO.deleteById(widgetId);
    }

    @Cacheable(value={"ide.widget"})
    public List<Widget> getWidgetsByProperties(Map<String, String> properties) {
        return this.widgetDAO.findAll(WidgetQueryBuilder.hasProperties(properties)).stream().map(Utils::fromEntity).toList();
    }

    public Widget getWidgetByPortletId(long portletInstanceId) {
        WidgetEntity widgetEntity = this.widgetDAO.findByPortletId(portletInstanceId);
        return widgetEntity == null ? null : Utils.fromEntity(widgetEntity);
    }

    public boolean existsByPortletInstanceId(Long portletInstanceId) {
        return this.widgetDAO.existsByPortletId(portletInstanceId);
    }
}

