/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import junit.framework.TestCase;
import org.exoplatform.services.log.impl.LogMessageFormatter;

public class TestLogMessageFormatter
extends TestCase {
    public void testMessageParsing() throws Exception {
        TestLogMessageFormatter.assertEquals((String)"Sometimes even the wisest of man or machine can make an error.", (String)LogMessageFormatter.getMessage((String)"Sometimes even the wisest of man or machine can make an {}.", (Object[])new Object[]{"error"}));
        TestLogMessageFormatter.assertEquals((String)"Time makes all things possible. I can wait.", (String)LogMessageFormatter.getMessage((String)"Time makes all {} possible. I can wait{}", (Object[])new Object[]{"things", "."}));
        TestLogMessageFormatter.assertEquals((String)"Give it up, Megatron!", (String)LogMessageFormatter.getMessage((String)"Give it up, Megatron!", (Object[])new Object[]{new Throwable()}));
        TestLogMessageFormatter.assertEquals((String)"Just remember, there's a thin line between being a hero and being a memory.", (String)LogMessageFormatter.getMessage((String)"Just remember, there's a thin line between being a hero and being a {}.", (Object[])new Object[]{"memory", new Throwable()}));
        TestLogMessageFormatter.assertEquals((String)"We can't stand by and watch the destruction of this beautiful planet.", (String)LogMessageFormatter.getMessage((String)"{}", (Object[])new Object[]{"We can't stand by and watch the destruction of this beautiful planet.", new Throwable()}));
    }

    public void testGetThrowable() throws Exception {
        Throwable t = new Throwable();
        TestLogMessageFormatter.assertNull((Object)LogMessageFormatter.getThrowable((Object[])new Object[0]));
        TestLogMessageFormatter.assertNull((Object)LogMessageFormatter.getThrowable((Object[])new Object[]{new Object()}));
        TestLogMessageFormatter.assertNull((Object)LogMessageFormatter.getThrowable((Object[])new Object[]{new Object(), t, new String()}));
        TestLogMessageFormatter.assertEquals((Object)t, (Object)LogMessageFormatter.getThrowable((Object[])new Object[]{new Object(), t}));
        TestLogMessageFormatter.assertEquals((Object)t, (Object)LogMessageFormatter.getThrowable((Object[])new Object[]{"Just testing{}", new Object(), t}));
    }

    public void testGetMessage() throws Exception {
        LogMessageFormatter.getMessage((String)"Hello, World {} ", (Object[])new Object[]{new A(this)});
        LogMessageFormatter.getMessage((String)"Hello, World {} {}", (Object[])new Object[]{new Object(), null});
    }

    public void testSpecialCharacterReplacement() throws Exception {
        TestLogMessageFormatter.assertEquals((String)"Hello, World $var", (String)LogMessageFormatter.getMessage((String)"Hello, World {}", (Object[])new Object[]{"$var"}));
        TestLogMessageFormatter.assertEquals((String)"Hello $foo and $bar", (String)LogMessageFormatter.getMessage((String)"Hello {} and {}", (Object[])new Object[]{"$foo", "$bar"}));
        TestLogMessageFormatter.assertEquals((String)"Counting one, two, three ... to $end", (String)LogMessageFormatter.getMessage((String)"Counting {} to {}", (Object[])new Object[]{"one, two, three ...", "$end"}));
    }

    class A {
        A(TestLogMessageFormatter this$0) {
        }

        public String toString() {
            return "";
        }
    }
}

