/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.test;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import junit.framework.TestCase;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CacheListenerContext;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.cache.concurrent.ConcurrentFIFOExoCache;

public class TestConcurrentCache
extends TestCase {
    private final Object v1 = new Object();
    private final Object v2 = new Object();
    private final Object v3 = new Object();
    private final Object v4 = new Object();
    private final Object v5 = new Object();

    public void testNullKey() {
        CacheHelper cache = new CacheHelper();
        cache.put((Serializable)((Object)"a"), "a");
        TestConcurrentCache.assertNull((Object)cache.get(null));
        try {
            cache.put(null, new Object());
            TestConcurrentCache.fail((String)"Was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException ignore) {
            TestConcurrentCache.assertEquals((int)1, (int)cache.getCacheSize());
            TestConcurrentCache.assertEquals((Object)"a", (Object)cache.get((Serializable)((Object)"a")));
        }
        try {
            cache.remove(null);
            TestConcurrentCache.fail((String)"Was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException ignore) {
            TestConcurrentCache.assertEquals((int)1, (int)cache.getCacheSize());
            TestConcurrentCache.assertEquals((Object)"a", (Object)cache.get((Serializable)((Object)"a")));
        }
        try {
            cache.putMap(null);
            TestConcurrentCache.fail((String)"Was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException ignore) {
            TestConcurrentCache.assertEquals((int)1, (int)cache.getCacheSize());
            TestConcurrentCache.assertEquals((Object)"a", (Object)cache.get((Serializable)((Object)"a")));
        }
        try {
            HashMap<String, String> tmp = new HashMap<String, String>();
            tmp.put("a", "a");
            tmp.put(null, "a");
            cache.putMap(tmp);
            TestConcurrentCache.fail((String)"Was expecting an IllegalArgumentException");
        }
        catch (IllegalArgumentException ignore) {
            TestConcurrentCache.assertEquals((int)1, (int)cache.getCacheSize());
            TestConcurrentCache.assertEquals((Object)"a", (Object)cache.get((Serializable)((Object)"a")));
        }
    }

    public void testPut() {
        CacheHelper cache = new CacheHelper();
        cache.put((Serializable)((Object)"Foo"), this.v1);
        cache.assertPut((Serializable)((Object)"Foo"), this.v1).assertEmpty();
        TestConcurrentCache.assertEquals((Object)this.v1, (Object)cache.get((Serializable)((Object)"Foo")));
        cache.assertGet((Serializable)((Object)"Foo"), this.v1).assertEmpty();
    }

    public void testCacheSize() {
        CacheHelper cache = new CacheHelper();
        TestConcurrentCache.assertEquals((int)0, (int)cache.getCacheSize());
        cache.put((Serializable)((Object)"Foo"), this.v1);
        TestConcurrentCache.assertEquals((int)1, (int)cache.getCacheSize());
        cache.put((Serializable)((Object)"Bar"), this.v2);
        TestConcurrentCache.assertEquals((int)2, (int)cache.getCacheSize());
        cache.put((Serializable)((Object)"Juu"), this.v3);
        TestConcurrentCache.assertEquals((int)2, (int)cache.getCacheSize());
    }

    public void testOverCapacity() {
        CacheHelper cache = new CacheHelper();
        cache.put((Serializable)((Object)"Foo"), this.v1);
        cache.assertPut((Serializable)((Object)"Foo"), this.v1).assertEmpty();
        cache.put((Serializable)((Object)"Bar"), this.v2);
        cache.assertPut((Serializable)((Object)"Bar"), this.v2).assertEmpty();
        cache.put((Serializable)((Object)"Juu"), this.v3);
        cache.assertExpire((Serializable)((Object)"Foo"), this.v1).assertPut((Serializable)((Object)"Juu"), this.v3).assertEmpty();
        TestConcurrentCache.assertEquals(null, (Object)cache.get((Serializable)((Object)"Foo")));
        TestConcurrentCache.assertEquals((Object)this.v2, (Object)cache.get((Serializable)((Object)"Bar")));
        TestConcurrentCache.assertEquals((Object)this.v3, (Object)cache.get((Serializable)((Object)"Juu")));
    }

    public void testPromotion() {
        CacheHelper cache = new CacheHelper();
        cache.put((Serializable)((Object)"Foo"), this.v1);
        cache.assertPut((Serializable)((Object)"Foo"), this.v1).assertEmpty();
        cache.put((Serializable)((Object)"Bar"), this.v2);
        cache.assertPut((Serializable)((Object)"Bar"), this.v2).assertEmpty();
        cache.put((Serializable)((Object)"Foo"), this.v3);
        cache.assertPut((Serializable)((Object)"Foo"), this.v3).assertEmpty();
        cache.put((Serializable)((Object)"Juu"), this.v4);
        cache.assertExpire((Serializable)((Object)"Bar"), this.v2).assertPut((Serializable)((Object)"Juu"), this.v4).assertEmpty();
        TestConcurrentCache.assertEquals((Object)this.v3, (Object)cache.get((Serializable)((Object)"Foo")));
        TestConcurrentCache.assertEquals(null, (Object)cache.get((Serializable)((Object)"Bar")));
        TestConcurrentCache.assertEquals((Object)this.v4, (Object)cache.get((Serializable)((Object)"Juu")));
    }

    public void testRemove() {
        CacheHelper cache = new CacheHelper();
        cache.put((Serializable)((Object)"Foo"), this.v1);
        cache.assertPut((Serializable)((Object)"Foo"), this.v1).assertEmpty();
        TestConcurrentCache.assertEquals((Object)this.v1, (Object)cache.remove((Serializable)((Object)"Foo")));
        cache.assertRemove((Serializable)((Object)"Foo"), this.v1).assertEmpty();
        TestConcurrentCache.assertEquals(null, (Object)cache.get((Serializable)((Object)"Foo")));
    }

    public void testExpireOnPut() {
        CacheHelper cache = new CacheHelper();
        cache.setMaxSize(4);
        cache.put((Serializable)((Object)"Foo"), this.v1);
        cache.assertPut((Serializable)((Object)"Foo"), this.v1).assertEmpty();
        cache.put((Serializable)((Object)"Bar"), this.v2);
        cache.assertPut((Serializable)((Object)"Bar"), this.v2).assertEmpty();
        cache.put((Serializable)((Object)"Juu"), this.v3);
        cache.assertPut((Serializable)((Object)"Juu"), this.v3).assertEmpty();
        cache.put((Serializable)((Object)"Daa"), this.v4);
        cache.assertPut((Serializable)((Object)"Daa"), this.v4).assertEmpty();
        cache.setMaxSize(2);
        cache.put((Serializable)((Object)"Boo"), this.v5);
        cache.assertExpire((Serializable)((Object)"Foo"), this.v1).assertExpire((Serializable)((Object)"Bar"), this.v2).assertExpire((Serializable)((Object)"Juu"), this.v3).assertPut((Serializable)((Object)"Boo"), this.v5).assertEmpty();
    }

    public void testExpireOnGet() {
        CacheHelper cache = new CacheHelper();
        cache.setLiveTimeMillis(15L);
        cache.put((Serializable)((Object)"Foo"), this.v1);
        cache.assertPut((Serializable)((Object)"Foo"), this.v1).assertEmpty();
        this.waitFor(25L);
        TestConcurrentCache.assertEquals(null, (Object)cache.get((Serializable)((Object)"Foo")));
        cache.assertExpire((Serializable)((Object)"Foo"), this.v1).assertEmpty();
    }

    public void testExpireOnRemove() {
        CacheHelper cache = new CacheHelper();
        cache.setLiveTimeMillis(15L);
        cache.put((Serializable)((Object)"Foo"), this.v1);
        cache.assertPut((Serializable)((Object)"Foo"), this.v1).assertEmpty();
        this.waitFor(25L);
        TestConcurrentCache.assertEquals(null, (Object)cache.remove((Serializable)((Object)"Foo")));
        cache.assertExpire((Serializable)((Object)"Foo"), this.v1).assertEmpty();
    }

    public void testGetCachedObjects() {
        CacheHelper cache = new CacheHelper(4);
        cache.put((Serializable)((Object)"Foo"), this.v1);
        cache.put((Serializable)((Object)"Bar"), this.v2);
        cache.put((Serializable)((Object)"Juu"), this.v3);
        HashSet cachedSet = new HashSet(cache.getCachedObjects());
        HashSet<Object> expectedSet = new HashSet<Object>();
        expectedSet.add(this.v1);
        expectedSet.add(this.v2);
        expectedSet.add(this.v3);
        TestConcurrentCache.assertEquals(expectedSet, cachedSet);
    }

    public void testHitRatio() {
        CacheHelper cache = new CacheHelper();
        cache.setLiveTimeMillis(5L);
        TestConcurrentCache.assertEquals((int)0, (int)cache.getCacheHit());
        TestConcurrentCache.assertEquals((int)0, (int)cache.getCacheMiss());
        cache.put((Serializable)((Object)"Foo"), this.v1);
        TestConcurrentCache.assertEquals((int)0, (int)cache.getCacheHit());
        TestConcurrentCache.assertEquals((int)0, (int)cache.getCacheMiss());
        TestConcurrentCache.assertEquals((Object)this.v1, (Object)cache.get((Serializable)((Object)"Foo")));
        TestConcurrentCache.assertEquals((int)1, (int)cache.getCacheHit());
        TestConcurrentCache.assertEquals((int)0, (int)cache.getCacheMiss());
        this.waitFor(10L);
        TestConcurrentCache.assertNull((Object)cache.get((Serializable)((Object)"Foo")));
        TestConcurrentCache.assertEquals((int)1, (int)cache.getCacheHit());
        TestConcurrentCache.assertEquals((int)1, (int)cache.getCacheMiss());
        TestConcurrentCache.assertNull((Object)cache.get((Serializable)((Object)"Foo")));
        TestConcurrentCache.assertEquals((int)1, (int)cache.getCacheHit());
        TestConcurrentCache.assertEquals((int)2, (int)cache.getCacheMiss());
    }

    public void testSelect() throws Exception {
        CacheHelper cache = new CacheHelper(4);
        cache.put((Serializable)((Object)"Foo"), this.v1);
        TestConcurrentCache.assertEquals((int)1, (int)cache.getCacheSize());
        cache.select((CachedObjectSelector)new CachedObjectSelector<String, Object>(){

            public boolean select(String key, ObjectCacheInfo<? extends Object> ocinfo) {
                return "Foo".equals(key) && TestConcurrentCache.this.v1.equals(ocinfo.get());
            }

            public void onSelect(ExoCache<? extends String, ? extends Object> cache, String key, ObjectCacheInfo<? extends Object> ocinfo) throws Exception {
                cache.remove((Serializable)((Object)key));
            }
        });
        TestConcurrentCache.assertEquals((int)0, (int)cache.getCacheSize());
    }

    private void waitFor(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            TestConcurrentCache.fail();
        }
    }

    private static class CacheHelper<K extends Serializable, V>
    extends ConcurrentFIFOExoCache<K, V>
    implements CacheListener<K, V> {
        private final LinkedList<Event> events = new LinkedList();

        CacheHelper() {
            super(2);
            this.addCacheListener(this);
        }

        CacheHelper(int maxSize) {
            super(maxSize);
            this.addCacheListener(this);
        }

        public CacheHelper assertRemove(Serializable key, Object object) {
            this.assertEntry(EntryEvent.Type.REMOVE, key, object);
            return this;
        }

        public CacheHelper assertPut(Serializable key, Object object) {
            this.assertEntry(EntryEvent.Type.PUT, key, object);
            return this;
        }

        public CacheHelper assertExpire(Serializable key, Object object) {
            this.assertEntry(EntryEvent.Type.EXPIRE, key, object);
            return this;
        }

        public CacheHelper assertGet(Serializable key, Object object) {
            this.assertEntry(EntryEvent.Type.GET, key, object);
            return this;
        }

        public CacheHelper assertClear() {
            TestCase.assertFalse((boolean)this.events.isEmpty());
            Event event = this.events.removeFirst();
            TestCase.assertNotNull((Object)event);
            TestCase.assertTrue((boolean)(event instanceof ClearEvent));
            return this;
        }

        public CacheHelper assertEntry(EntryEvent.Type type, Serializable key, Object object) {
            TestCase.assertFalse((boolean)this.events.isEmpty());
            Event event = this.events.removeFirst();
            TestCase.assertNotNull((Object)event);
            TestCase.assertTrue((boolean)(event instanceof EntryEvent));
            EntryEvent entryEvent = (EntryEvent)event;
            TestCase.assertEquals((Object)((Object)type), (Object)((Object)entryEvent.type));
            TestCase.assertEquals((Object)key, (Object)entryEvent.key);
            TestCase.assertEquals((Object)object, (Object)entryEvent.object);
            return this;
        }

        public CacheHelper assertEmpty() {
            TestCase.assertTrue((boolean)this.events.isEmpty());
            return this;
        }

        public void onExpire(CacheListenerContext context, K key, V obj) throws Exception {
            this.events.addLast(new EntryEvent(EntryEvent.Type.EXPIRE, (Serializable)key, obj));
        }

        public void onRemove(CacheListenerContext context, K key, V obj) throws Exception {
            this.events.addLast(new EntryEvent(EntryEvent.Type.REMOVE, (Serializable)key, obj));
        }

        public void onPut(CacheListenerContext context, K key, V obj) throws Exception {
            this.events.addLast(new EntryEvent(EntryEvent.Type.PUT, (Serializable)key, obj));
        }

        public void onGet(CacheListenerContext context, K key, V obj) throws Exception {
            this.events.addLast(new EntryEvent(EntryEvent.Type.GET, (Serializable)key, obj));
        }

        public void onClearCache(CacheListenerContext context) throws Exception {
            this.events.addLast(new ClearEvent());
        }

        private static class EntryEvent
        extends Event {
            private final Type type;
            private final Serializable key;
            private final Object object;

            private EntryEvent(Type type, Serializable key, Object object) {
                this.type = type;
                this.key = key;
                this.object = object;
            }

            private static enum Type {
                EXPIRE,
                REMOVE,
                PUT,
                GET;

            }
        }

        private static class Event {
            private Event() {
            }
        }

        private static class ClearEvent
        extends Event {
            private ClearEvent() {
            }
        }
    }
}

