/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache;

import org.exoplatform.services.cache.CacheMode;

public class ExoCacheConfig
implements Cloneable {
    private String name;
    private String label;
    private int maxSize;
    private long liveTime;
    @Deprecated
    private boolean distributed;
    @Deprecated
    private boolean replicated;
    private String implementation;
    private boolean logEnabled;
    @Deprecated
    public boolean avoidValueReplication;
    private String cacheMode;
    private CacheMode topology;

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String s) {
        this.label = s;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int size) {
        this.maxSize = size;
    }

    public long getLiveTime() {
        return this.liveTime;
    }

    public void setLiveTime(long period) {
        this.liveTime = period;
    }

    public boolean isDistributed() {
        return this.distributed || this.getCacheMode().isDistributed();
    }

    public void setDistributed(boolean b) {
        this.distributed = b;
    }

    public boolean isRepicated() {
        return this.replicated || !this.getCacheMode().isLocal();
    }

    public void setReplicated(boolean b) {
        this.replicated = b;
    }

    public boolean isAsync() {
        return !this.getCacheMode().isSync() && !this.getCacheMode().isLocal();
    }

    public boolean isInvalidated() {
        return this.getCacheMode().isInvalidated();
    }

    public String getImplementation() {
        return this.implementation;
    }

    public void setImplementation(String alg) {
        this.implementation = alg;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    public void setLogEnabled(boolean enableLogging) {
        this.logEnabled = enableLogging;
    }

    public boolean avoidValueReplication() {
        return this.avoidValueReplication || this.getCacheMode() == CacheMode.SYNCINVALIDATION;
    }

    public void setCacheMode(CacheMode cacheMode) {
        this.topology = cacheMode;
    }

    public CacheMode getCacheMode() {
        return this.initCacheMode();
    }

    public ExoCacheConfig clone() throws CloneNotSupportedException {
        return (ExoCacheConfig)super.clone();
    }

    private CacheMode initCacheMode() {
        try {
            if (this.cacheMode == null) {
                this.topology = this.replicated ? CacheMode.REPLICATION : (this.distributed ? CacheMode.DISTRIBUTED : (this.avoidValueReplication ? CacheMode.SYNCINVALIDATION : CacheMode.LOCAL));
            }
            this.topology = CacheMode.valueOf(this.cacheMode.toUpperCase());
        }
        catch (Exception e) {
            this.topology = CacheMode.LOCAL;
        }
        return this.topology;
    }
}

