/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.concurrent;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.exoplatform.services.cache.concurrent.Item;
import org.exoplatform.services.cache.concurrent.Queue;
import org.exoplatform.services.log.Log;

public class SynchronizedQueue<I extends Item>
implements Queue<I> {
    private final Log log;
    private final Item head;
    private final Item tail;
    volatile int queueSize;
    private final Lock queueLock = new ReentrantLock();
    private volatile AtomicBoolean trimming = new AtomicBoolean();

    public SynchronizedQueue(Log log) {
        this.log = log;
        this.head = new Item();
        this.tail = new Item();
        this.queueSize = 0;
        this.head.next = this.tail;
        this.tail.previous = this.head;
        if (this.isTraceEnabled()) {
            this.trace("Queue initialized with first=" + this.head.serial + " and last=" + this.tail.serial);
        }
    }

    private boolean isTraceEnabled() {
        return this.log != null && this.log.isTraceEnabled();
    }

    private void trace(String message) {
        this.log.trace((Object)(message + " [" + Thread.currentThread().getName() + "]"));
    }

    @Override
    public int size() {
        return this.queueSize;
    }

    public void assertConsistency() {
        int cachedQueueSize = this.queueSize;
        int effectiveQueueSize = 0;
        Item item = this.head.next;
        while (item != this.tail) {
            ++effectiveQueueSize;
            item = item.next;
        }
        if (effectiveQueueSize != cachedQueueSize) {
            throw new AssertionError((Object)("The cached queue size " + cachedQueueSize + "  is different from the effective queue size" + effectiveQueueSize));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(I item) {
        boolean trace = this.isTraceEnabled();
        this.queueLock.lock();
        try {
            Item previous = ((Item)item).previous;
            Item next = ((Item)item).next;
            if (previous != null && next != null) {
                previous.next = next;
                next.previous = previous;
                ((Item)item).previous = null;
                ((Item)item).next = null;
                int newSize = --this.queueSize;
                if (trace) {
                    this.trace("Removed item=" + ((Item)item).serial + " with previous=" + previous.serial + " and next=" + next.serial + " with queue=" + newSize);
                }
                boolean bl = true;
                return bl;
            }
            if (trace) {
                this.trace("Attempt to remove item=" + ((Item)item).serial + " concurrently removed");
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(I item) {
        this.queueLock.lock();
        try {
            Item next;
            ((Item)item).next = next = this.head.next;
            next.previous = item;
            this.head.next = item;
            ((Item)item).previous = this.head;
            int newSize = ++this.queueSize;
            if (this.isTraceEnabled()) {
                this.trace("Added item=" + ((Item)item).serial + " with next=" + next.serial + " and queue=" + newSize);
            }
        }
        finally {
            this.queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<I> trim(int size) {
        if (this.trimming.compareAndSet(false, true)) {
            try {
                this.queueLock.lock();
                if (this.queueSize > size) {
                    ArrayList<Item> evictedItems = new ArrayList<Item>(this.queueSize - size);
                    while (this.queueSize > size) {
                        Item last = this.tail.previous;
                        this.remove(last);
                        evictedItems.add(last);
                    }
                    ArrayList<Item> arrayList = evictedItems;
                    return arrayList;
                }
            }
            finally {
                this.trimming.set(false);
                this.queueLock.unlock();
            }
        }
        return null;
    }
}

