/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.concurrent;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.exoplatform.services.cache.concurrent.ConcurrentFIFOExoCache;
import org.junit.Assert;
import org.junit.Test;

public class TestConcurrentFIFOExoCache {
    private int LIMIT = 1000;

    @Test
    public void testPut() throws Exception {
        final ConcurrentFIFOExoCache cache = new ConcurrentFIFOExoCache(this.LIMIT);
        final CountDownLatch start = new CountDownLatch(1);
        final CountDownLatch finish = new CountDownLatch(1000);
        for (int i = 0; i < 1000; ++i) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        start.await(10L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        Assert.fail((String)"CountDownLatch fail to wait");
                    }
                    for (int j = 0; j < 10000; ++j) {
                        if (cache.getCacheSize() > TestConcurrentFIFOExoCache.this.LIMIT) continue;
                        cache.put((Serializable)((Object)""), (Object)"");
                    }
                    finish.countDown();
                }
            });
            t.start();
        }
        start.countDown();
        finish.await(1L, TimeUnit.MINUTES);
        Assert.assertEquals((long)this.LIMIT, (long)cache.getCacheSize());
    }
}

